/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.sort;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.ProgramDescription;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.java.record.functions.FunctionAnnotation;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.io.CsvInputFormat;
import eu.stratosphere.api.java.record.io.CsvOutputFormat;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Iterator;

public class ReduceGroupSort
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;

    public Plan getPlan(String ... args) {
        int numSubTasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String dataInput = args.length > 1 ? args[1] : "";
        String output = args.length > 2 ? args[2] : "";
        CsvInputFormat format = new CsvInputFormat(' ', new Class[]{IntValue.class, IntValue.class});
        FileDataSource input = new FileDataSource((FileInputFormat)format, dataInput, "Input");
        ReduceOperator sorter = ReduceOperator.builder((ReduceFunction)new IdentityReducer(), IntValue.class, (int)0).input(new Operator[]{input}).name("Reducer").build();
        sorter.setGroupOrder(new Ordering(1, IntValue.class, Order.ASCENDING));
        FileDataSink out = new FileDataSink((FileOutputFormat)new CsvOutputFormat(), output, (Operator)sorter, "Sorted Output");
        ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)out).recordDelimiter('\n')).fieldDelimiter(' ')).field(IntValue.class, 0)).field(IntValue.class, 1);
        Plan plan = new Plan((GenericDataSink)out, "SecondarySort Example");
        plan.setDefaultParallelism(numSubTasks);
        return plan;
    }

    public String getDescription() {
        return "Parameters: [numSubStasks] [input] [output]";
    }

    @FunctionAnnotation.ConstantFieldsExcept(value={0})
    public static class IdentityReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void reduce(Iterator<Record> records, Collector<Record> out) {
            Record next = records.next();
            IntValue incrVal = (IntValue)next.getField(0, IntValue.class);
            incrVal.setValue(incrVal.getValue() + 100);
            next.setField(0, (Value)incrVal);
            out.collect((Object)next);
            while (records.hasNext()) {
                out.collect((Object)records.next());
            }
        }
    }
}

