/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.relational.query1Util;

import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.test.recordJobs.util.Tuple;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class LineItemFilter
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(LineItemFilter.class);
    private static final String DATE_CONSTANT = "1998-09-03";
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private final Date constantDate;

    public LineItemFilter() {
        try {
            this.constantDate = format.parse(DATE_CONSTANT);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Date constant could not be parsed.", (Throwable)e);
            throw new RuntimeException("Date constant could not be parsed.");
        }
    }

    public void map(Record record, Collector<Record> out) throws Exception {
        Tuple value = (Tuple)record.getField(1, Tuple.class);
        if (value != null && value.getNumberOfColumns() >= 11) {
            String shipDateString = value.getStringValueAt(10);
            try {
                Date shipDate = format.parse(shipDateString);
                if (shipDate.before(this.constantDate)) {
                    String returnFlag = value.getStringValueAt(8);
                    record.setField(0, (Value)new StringValue((CharSequence)returnFlag));
                    out.collect((Object)record);
                }
            }
            catch (ParseException e) {
                LOGGER.error((Object)e);
            }
        }
    }
}

