/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.relational;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.ProgramDescription;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.operators.JoinOperator;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.test.recordJobs.relational.query9Util.AmountAggregate;
import eu.stratosphere.test.recordJobs.relational.query9Util.FilteredPartsJoin;
import eu.stratosphere.test.recordJobs.relational.query9Util.IntPair;
import eu.stratosphere.test.recordJobs.relational.query9Util.LineItemMap;
import eu.stratosphere.test.recordJobs.relational.query9Util.OrderMap;
import eu.stratosphere.test.recordJobs.relational.query9Util.OrderedPartsJoin;
import eu.stratosphere.test.recordJobs.relational.query9Util.PartFilter;
import eu.stratosphere.test.recordJobs.relational.query9Util.PartJoin;
import eu.stratosphere.test.recordJobs.relational.query9Util.PartListJoin;
import eu.stratosphere.test.recordJobs.relational.query9Util.PartsuppMap;
import eu.stratosphere.test.recordJobs.relational.query9Util.StringIntPair;
import eu.stratosphere.test.recordJobs.relational.query9Util.StringIntPairStringDataOutFormat;
import eu.stratosphere.test.recordJobs.relational.query9Util.SupplierMap;
import eu.stratosphere.test.recordJobs.relational.query9Util.SuppliersJoin;
import eu.stratosphere.test.recordJobs.util.IntTupleDataInFormat;
import eu.stratosphere.types.IntValue;
import org.apache.log4j.Logger;

public class TPCHQuery9
implements Program,
ProgramDescription {
    public final String ARGUMENTS = "dop partInputPath partSuppInputPath ordersInputPath lineItemInputPath supplierInputPath nationInputPath outputPath";
    private static Logger LOGGER = Logger.getLogger(TPCHQuery9.class);
    private int degreeOfParallelism = 1;
    private String partInputPath;
    private String partSuppInputPath;
    private String ordersInputPath;
    private String lineItemInputPath;
    private String supplierInputPath;
    private String nationInputPath;
    private String outputPath;

    public Plan getPlan(String ... args) throws IllegalArgumentException {
        if (args.length != 8) {
            LOGGER.warn((Object)"number of arguments do not match!");
            this.degreeOfParallelism = 1;
            this.partInputPath = "";
            this.partSuppInputPath = "";
            this.ordersInputPath = "";
            this.lineItemInputPath = "";
            this.supplierInputPath = "";
            this.nationInputPath = "";
            this.outputPath = "";
        } else {
            this.degreeOfParallelism = Integer.parseInt(args[0]);
            this.partInputPath = args[1];
            this.partSuppInputPath = args[2];
            this.ordersInputPath = args[3];
            this.lineItemInputPath = args[4];
            this.supplierInputPath = args[5];
            this.nationInputPath = args[6];
            this.outputPath = args[7];
        }
        FileDataSource partInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.partInputPath, "\"part\" source");
        FileDataSource partSuppInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.partSuppInputPath, "\"partsupp\" source");
        FileDataSource ordersInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.ordersInputPath, "\"orders\" source");
        FileDataSource lineItemInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.lineItemInputPath, "\"lineitem\" source");
        FileDataSource supplierInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.supplierInputPath, "\"supplier\" source");
        FileDataSource nationInput = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.nationInputPath, "\"nation\" source");
        MapOperator filterPart = MapOperator.builder(PartFilter.class).name("filterParts").build();
        MapOperator mapPartsupp = MapOperator.builder(PartsuppMap.class).name("mapPartsupp").build();
        MapOperator mapOrder = MapOperator.builder(OrderMap.class).name("mapOrder").build();
        MapOperator mapLineItem = MapOperator.builder(LineItemMap.class).name("proj.Partsupp").build();
        MapOperator mapSupplier = MapOperator.builder(SupplierMap.class).name("proj.Partsupp").build();
        JoinOperator partsJoin = JoinOperator.builder(PartJoin.class, IntValue.class, (int)0, (int)0).name("partsJoin").build();
        JoinOperator orderedPartsJoin = JoinOperator.builder(OrderedPartsJoin.class, IntValue.class, (int)0, (int)0).name("orderedPartsJoin").build();
        JoinOperator suppliersJoin = JoinOperator.builder(SuppliersJoin.class, IntValue.class, (int)0, (int)0).name("suppliersJoin").build();
        JoinOperator filteredPartsJoin = JoinOperator.builder(FilteredPartsJoin.class, IntPair.class, (int)0, (int)0).name("filteredPartsJoin").build();
        JoinOperator partListJoin = JoinOperator.builder(PartListJoin.class, IntValue.class, (int)0, (int)0).name("partlistJoin").build();
        ReduceOperator sumAmountAggregate = ReduceOperator.builder(AmountAggregate.class, StringIntPair.class, (int)0).name("groupyBy").build();
        filterPart.setInput((Operator)partInput);
        mapPartsupp.setInput((Operator)partSuppInput);
        mapOrder.setInput((Operator)ordersInput);
        mapLineItem.setInput((Operator)lineItemInput);
        mapSupplier.setInput((Operator)supplierInput);
        partsJoin.setFirstInput((Operator)filterPart);
        partsJoin.setSecondInput((Operator)mapPartsupp);
        orderedPartsJoin.setFirstInput((Operator)mapOrder);
        orderedPartsJoin.setSecondInput((Operator)mapLineItem);
        suppliersJoin.setFirstInput((Operator)mapSupplier);
        suppliersJoin.setSecondInput((Operator)nationInput);
        filteredPartsJoin.setFirstInput((Operator)partsJoin);
        filteredPartsJoin.setSecondInput((Operator)orderedPartsJoin);
        partListJoin.setFirstInput((Operator)filteredPartsJoin);
        partListJoin.setSecondInput((Operator)suppliersJoin);
        sumAmountAggregate.setInput((Operator)partListJoin);
        FileDataSink result = new FileDataSink((FileOutputFormat)new StringIntPairStringDataOutFormat(), this.outputPath, "Results sink");
        result.setInput((Operator)sumAmountAggregate);
        Plan p = new Plan((GenericDataSink)result, "TPC-H query 9");
        p.setDefaultParallelism(this.degreeOfParallelism);
        return p;
    }

    public String getDescription() {
        return "TPC-H query 9, parameters: " + this.ARGUMENTS;
    }
}

