/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.relational;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.ProgramDescription;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.test.recordJobs.relational.query1Util.GroupByReturnFlag;
import eu.stratosphere.test.recordJobs.relational.query1Util.LineItemFilter;
import eu.stratosphere.test.recordJobs.util.IntTupleDataInFormat;
import eu.stratosphere.test.recordJobs.util.StringTupleDataOutFormat;
import eu.stratosphere.types.StringValue;

public class TPCHQuery1
implements Program,
ProgramDescription {
    private static final long serialVersionUID = 1L;
    private int degreeOfParallelism = 1;
    private String lineItemInputPath;
    private String outputPath;

    public Plan getPlan(String ... args) throws IllegalArgumentException {
        if (args.length != 3) {
            this.degreeOfParallelism = 1;
            this.lineItemInputPath = "";
            this.outputPath = "";
        } else {
            this.degreeOfParallelism = Integer.parseInt(args[0]);
            this.lineItemInputPath = args[1];
            this.outputPath = args[2];
        }
        FileDataSource lineItems = new FileDataSource((FileInputFormat)new IntTupleDataInFormat(), this.lineItemInputPath, "LineItems");
        lineItems.setDegreeOfParallelism(this.degreeOfParallelism);
        FileDataSink result = new FileDataSink((FileOutputFormat)new StringTupleDataOutFormat(), this.outputPath, "Output");
        result.setDegreeOfParallelism(this.degreeOfParallelism);
        MapOperator lineItemFilter = MapOperator.builder((MapFunction)new LineItemFilter()).name("LineItem Filter").build();
        lineItemFilter.setDegreeOfParallelism(this.degreeOfParallelism);
        ReduceOperator groupByReturnFlag = ReduceOperator.builder((ReduceFunction)new GroupByReturnFlag(), StringValue.class, (int)0).name("groupyBy").build();
        lineItemFilter.setInput((Operator)lineItems);
        groupByReturnFlag.setInput((Operator)lineItemFilter);
        result.setInput((Operator)groupByReturnFlag);
        return new Plan((GenericDataSink)result, "TPC-H 1");
    }

    public String getDescription() {
        return "Parameters: [dop] [lineitem-input] [output]";
    }
}

