/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.kmeans.udfs;

import eu.stratosphere.api.java.record.functions.CrossFunction;
import eu.stratosphere.api.java.record.functions.FunctionAnnotation;
import eu.stratosphere.test.recordJobs.kmeans.udfs.CoordVector;
import eu.stratosphere.types.DoubleValue;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;

@FunctionAnnotation.ConstantFieldsFirst(value={0, 1})
public class ComputeDistance
extends CrossFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DoubleValue distance = new DoubleValue();

    public void cross(Record dataPointRecord, Record clusterCenterRecord, Collector<Record> out) {
        CoordVector dataPoint = (CoordVector)dataPointRecord.getField(1, CoordVector.class);
        IntValue clusterCenterId = (IntValue)clusterCenterRecord.getField(0, IntValue.class);
        CoordVector clusterPoint = (CoordVector)clusterCenterRecord.getField(1, CoordVector.class);
        this.distance.setValue(dataPoint.computeEuclidianDistance(clusterPoint));
        dataPointRecord.setField(2, (Value)clusterCenterId);
        dataPointRecord.setField(3, (Value)this.distance);
        out.collect((Object)dataPointRecord);
    }
}

