/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.graph.pageRankUtil;

import eu.stratosphere.api.common.aggregators.Aggregator;
import eu.stratosphere.test.recordJobs.graph.pageRankUtil.PageRankStats;

public class PageRankStatsAggregator
implements Aggregator<PageRankStats> {
    private double diff = 0.0;
    private double rank = 0.0;
    private double danglingRank = 0.0;
    private long numDanglingVertices = 0L;
    private long numVertices = 0L;
    private long edges = 0L;

    public PageRankStats getAggregate() {
        return new PageRankStats(this.diff, this.rank, this.danglingRank, this.numDanglingVertices, this.numVertices, this.edges);
    }

    public void aggregate(double diffDelta, double rankDelta, double danglingRankDelta, long danglingVerticesDelta, long verticesDelta, long edgesDelta) {
        this.diff += diffDelta;
        this.rank += rankDelta;
        this.danglingRank += danglingRankDelta;
        this.numDanglingVertices += danglingVerticesDelta;
        this.numVertices += verticesDelta;
        this.edges += edgesDelta;
    }

    public void aggregate(PageRankStats pageRankStats) {
        this.diff += pageRankStats.diff();
        this.rank += pageRankStats.rank();
        this.danglingRank += pageRankStats.danglingRank();
        this.numDanglingVertices += pageRankStats.numDanglingVertices();
        this.numVertices += pageRankStats.numVertices();
        this.edges += pageRankStats.edges();
    }

    public void reset() {
        this.diff = 0.0;
        this.rank = 0.0;
        this.danglingRank = 0.0;
        this.numDanglingVertices = 0L;
        this.numVertices = 0L;
        this.edges = 0L;
    }
}

