/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobs.graph.pageRankUtil;

import eu.stratosphere.types.Value;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongArrayView
implements Value {
    private static final long serialVersionUID = 1L;
    private long[] entries = new long[0];
    private int numEntries = 0;

    public long get(int index) {
        if (index >= this.numEntries) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getQuick(index);
    }

    public long getQuick(int index) {
        return this.entries[index];
    }

    public void allocate(int numEntries) {
        this.numEntries = numEntries;
        this.ensureCapacity();
    }

    public void set(int index, long value) {
        if (index >= this.numEntries) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setQuick(index, value);
    }

    public void setQuick(int index, long value) {
        this.entries[index] = value;
    }

    public int size() {
        return this.numEntries;
    }

    private void ensureCapacity() {
        if (this.entries.length < this.numEntries) {
            this.entries = new long[this.numEntries];
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.numEntries);
        for (int n = 0; n < this.numEntries; ++n) {
            out.writeLong(this.entries[n]);
        }
    }

    public void read(DataInput in) throws IOException {
        this.numEntries = in.readInt();
        this.ensureCapacity();
        for (int n = 0; n < this.numEntries; ++n) {
            this.entries[n] = in.readLong();
        }
    }
}

