/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.distributions.DataDistribution;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.java.record.io.CsvInputFormat;
import eu.stratosphere.api.java.record.io.CsvOutputFormat;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Key;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class GlobalSortingMixedOrderITCase
extends RecordAPITestBase {
    private static final int NUM_RECORDS = 100000;
    private static final int RANGE_I1 = 100;
    private static final int RANGE_I2 = 20;
    private static final int RANGE_I3 = 20;
    private String recordsPath;
    private String resultPath;
    private String sortedRecords;

    protected void preSubmit() throws Exception {
        ArrayList<TripleInt> records = new ArrayList<TripleInt>();
        Random rnd = new Random(1988L);
        StringBuilder sb = new StringBuilder(700000);
        for (int j = 0; j < 100000; ++j) {
            TripleInt val = new TripleInt(rnd.nextInt(100), rnd.nextInt(20), rnd.nextInt(20));
            records.add(val);
            sb.append(val);
            sb.append('\n');
        }
        this.recordsPath = this.createTempFile("records", sb.toString());
        this.resultPath = this.getTempDirPath("result");
        Collections.sort(records);
        sb.setLength(0);
        for (TripleInt val : records) {
            sb.append(val);
            sb.append('\n');
        }
        this.sortedRecords = sb.toString();
    }

    protected Plan getTestJob() {
        GlobalSort globalSort = new GlobalSort();
        return globalSort.getPlan("4", this.recordsPath, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemoryWithStrictOrder(this.sortedRecords, this.resultPath);
    }

    private static final class TripleInt
    implements Comparable<TripleInt> {
        private final int i1;
        private final int i2;
        private final int i3;

        private TripleInt(int i1, int i2, int i3) {
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder(32);
            bld.append(this.i1);
            bld.append(',');
            bld.append(this.i2);
            bld.append(',');
            bld.append(this.i3);
            return bld.toString();
        }

        @Override
        public int compareTo(TripleInt o) {
            return this.i1 < o.i1 ? 1 : (this.i1 > o.i1 ? -1 : (this.i2 < o.i2 ? -1 : (this.i2 > o.i2 ? 1 : (this.i3 < o.i3 ? 1 : (this.i3 > o.i3 ? -1 : 0)))));
        }
    }

    private static class GlobalSort
    implements Program {
        private static final long serialVersionUID = 1L;

        private GlobalSort() {
        }

        public Plan getPlan(String ... args) throws IllegalArgumentException {
            int numSubtasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
            String recordsPath = args.length > 1 ? args[1] : "";
            String output = args.length > 2 ? args[2] : "";
            FileDataSource source = new FileDataSource((FileInputFormat)new CsvInputFormat(',', new Class[]{IntValue.class, IntValue.class, IntValue.class}), recordsPath);
            FileDataSink sink = new FileDataSink(CsvOutputFormat.class, output);
            ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)sink).recordDelimiter('\n')).fieldDelimiter(',')).lenient(true)).field(IntValue.class, 0)).field(IntValue.class, 1)).field(IntValue.class, 2);
            sink.setGlobalOrder(new Ordering(0, IntValue.class, Order.DESCENDING).appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING).appendOrdering(Integer.valueOf(2), IntValue.class, Order.DESCENDING), (DataDistribution)new TripleIntDistribution(Order.DESCENDING, Order.ASCENDING, Order.DESCENDING));
            sink.setInput((Operator)source);
            Plan p = new Plan((GenericDataSink)sink);
            p.setDefaultParallelism(numSubtasks);
            return p;
        }
    }

    public static class TripleIntDistribution
    implements DataDistribution {
        private static final long serialVersionUID = 1L;
        private boolean ascendingI1;
        private boolean ascendingI2;
        private boolean ascendingI3;

        public TripleIntDistribution(Order orderI1, Order orderI2, Order orderI3) {
            this.ascendingI1 = orderI1 != Order.DESCENDING;
            this.ascendingI2 = orderI2 != Order.DESCENDING;
            this.ascendingI3 = orderI3 != Order.DESCENDING;
        }

        public TripleIntDistribution() {
        }

        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.ascendingI1);
            out.writeBoolean(this.ascendingI2);
            out.writeBoolean(this.ascendingI3);
        }

        public void read(DataInput in) throws IOException {
            this.ascendingI1 = in.readBoolean();
            this.ascendingI2 = in.readBoolean();
            this.ascendingI3 = in.readBoolean();
        }

        public Key<?>[] getBucketBoundary(int bucketNum, int totalNumBuckets) {
            float bucketWidth = 100.0f / (float)totalNumBuckets;
            int boundVal = (int)((float)(bucketNum + 1) * bucketWidth);
            if (!this.ascendingI1) {
                boundVal = 100 - boundVal;
            }
            return new Key[]{new IntValue(boundVal), new IntValue(20), new IntValue(20)};
        }

        public int getNumberOfFields() {
            return 3;
        }
    }
}

