/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.recordJobTests;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.recordJobs.graph.EnumTrianglesRdfFoaf;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EnumTrianglesRDFITCase
extends RecordAPITestBase {
    String edgesPath = null;
    String resultPath = null;
    private static final String EDGES = "<a> <http://xmlns.com/foaf/0.1/knows> <b>\n<a> <http://xmlns.com/foaf/0.1/knows> <c>\n<a> <http://xmlns.com/foaf/0.1/knows> <d>\n<b> <http://xmlns.com/foaf/0.1/knows> <c>\n<b> <http://xmlns.com/foaf/0.1/knows> <e>\n<b> <http://xmlns.com/foaf/0.1/knows> <f>\n<c> <http://xmlns.com/foaf/0.1/knows> <d>\n<d> <http://xmlns.com/foaf/0.1/knows> <b>\n<f> <http://xmlns.com/foaf/0.1/knows> <g>\n<f> <http://xmlns.com/foaf/0.1/knows> <h>\n<f> <http://xmlns.com/foaf/0.1/knows> <i>\n<g> <http://xmlns.com/foaf/0.1/knows> <i>\n<g> <http://willNotWork> <h>\n";
    private static final String EXPECTED = "<a> <b> <c>\n<a> <b> <d>\n<a> <c> <d>\n<b> <c> <d>\n<f> <g> <i>\n";

    public EnumTrianglesRDFITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.edgesPath = this.createTempFile("edges.txt", EDGES);
        this.resultPath = this.getTempDirPath("triangles");
    }

    protected Plan getTestJob() {
        EnumTrianglesRdfFoaf enumTriangles = new EnumTrianglesRdfFoaf();
        return enumTriangles.getPlan(this.config.getString("EnumTrianglesTest#NoSubtasks", "4"), this.edgesPath, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(EXPECTED, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config = new Configuration();
        config.setInteger("EnumTrianglesTest#NoSubtasks", 4);
        return EnumTrianglesRDFITCase.toParameterList((Configuration[])new Configuration[]{config});
    }
}

