/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.operators;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plantranslate.NepheleJobGraphGenerator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import eu.stratosphere.test.operators.io.ContractITCaseIOFormats;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnionSinkITCase
extends RecordAPITestBase {
    private static final String MAP_IN = "1 1\n2 2\n2 8\n4 4\n4 4\n6 6\n7 7\n8 8\n1 1\n2 2\n2 2\n4 4\n4 4\n6 3\n5 9\n8 8\n1 1\n2 2\n2 2\n3 0\n4 4\n5 9\n7 7\n8 8\n1 1\n9 1\n5 9\n4 4\n4 4\n6 6\n7 7\n8 8\n";
    private static final String MAP_RESULT = "1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n";
    private static final String EMPTY_MAP_RESULT = "";
    private static final String MAP_RESULT_TWICE = "1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n";
    private String textInput;
    private String emptyInput;
    private String resultDir;

    public UnionSinkITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.textInput = this.createTempFile("textdata.txt", MAP_IN);
        this.emptyInput = this.createTempFile("emptyfile.txt", EMPTY_MAP_RESULT);
        this.resultDir = this.getTempDirPath("result");
    }

    protected JobGraph getJobGraph() throws Exception {
        String path1 = this.config.getBoolean("input1PathHasData", false) ? this.textInput : this.emptyInput;
        String path2 = this.config.getBoolean("input2PathHasData", false) ? this.textInput : this.emptyInput;
        FileDataSource input1 = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), path1);
        FileDataSource input2 = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), path2);
        MapOperator testMapper1 = MapOperator.builder((MapFunction)new TestMapper()).build();
        MapOperator testMapper2 = MapOperator.builder((MapFunction)new TestMapper()).build();
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultDir);
        testMapper1.setInput((Operator)input1);
        testMapper2.setInput((Operator)input2);
        output.addInput(new Operator[]{testMapper1});
        output.addInput(new Operator[]{testMapper2});
        Plan plan = new Plan((GenericDataSink)output);
        plan.setDefaultParallelism(4);
        PactCompiler pc = new PactCompiler(new DataStatistics());
        OptimizedPlan op = pc.compile(plan);
        NepheleJobGraphGenerator jgg = new NepheleJobGraphGenerator();
        return jgg.compileJobGraph(op);
    }

    protected void postSubmit() throws Exception {
        String expectedResult = this.config.getString("UnionTest#ExpectedResult", null);
        if (expectedResult == null) {
            throw new Exception("Test corrupt, no expected return data set.");
        }
        this.compareResultsByLinesInMemory(expectedResult, this.resultDir);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config1 = new Configuration();
        config1.setString("UnionTest#ExpectedResult", MAP_RESULT);
        config1.setBoolean("input1PathHasData", true);
        config1.setBoolean("input2PathHasData", false);
        Configuration config2 = new Configuration();
        config2.setString("UnionTest#ExpectedResult", MAP_RESULT);
        config2.setBoolean("input1PathHasData", false);
        config2.setBoolean("input2PathHasData", true);
        Configuration config3 = new Configuration();
        config3.setString("UnionTest#ExpectedResult", MAP_RESULT_TWICE);
        config3.setBoolean("input1PathHasData", true);
        config3.setBoolean("input2PathHasData", true);
        Configuration config4 = new Configuration();
        config4.setString("UnionTest#ExpectedResult", EMPTY_MAP_RESULT);
        config4.setBoolean("input1PathHasData", false);
        config4.setBoolean("input2PathHasData", false);
        return UnionSinkITCase.toParameterList((Configuration[])new Configuration[]{config1, config2, config3, config4});
    }

    public static class TestMapper
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue keyString = new StringValue();
        private StringValue valueString = new StringValue();

        public void map(Record record, Collector<Record> out) throws Exception {
            this.keyString = (StringValue)record.getField(0, (Value)this.keyString);
            this.valueString = (StringValue)record.getField(1, (Value)this.valueString);
            if (Integer.parseInt(this.keyString.toString()) + Integer.parseInt(this.valueString.toString()) < 10) {
                record.setField(0, (Value)this.valueString);
                record.setField(1, (Value)new IntValue(Integer.parseInt(this.keyString.toString()) + 10));
                out.collect((Object)record);
            }
        }
    }
}

