/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.operators;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plantranslate.NepheleJobGraphGenerator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import eu.stratosphere.test.operators.io.ContractITCaseIOFormats;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReduceITCase
extends RecordAPITestBase {
    private static final Log LOG = LogFactory.getLog(ReduceITCase.class);
    String inPath = null;
    String resultPath = null;
    private static final String IN = "1 1\n2 2\n2 8\n4 4\n4 4\n6 6\n7 7\n8 8\n1 1\n2 2\n2 2\n4 4\n4 4\n6 3\n5 9\n8 8\n1 1\n2 2\n2 2\n3 0\n4 4\n5 9\n7 7\n8 8\n1 1\n9 1\n5 9\n4 4\n4 4\n6 6\n7 7\n8 8\n";
    private static final String RESULT = "1 4\n2 18\n3 0\n4 28\n5 27\n6 15\n7 21\n8 32\n9 1\n";

    public ReduceITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.inPath = this.createTempFile("in.txt", IN);
        this.resultPath = this.getTempDirPath("result");
    }

    protected JobGraph getJobGraph() throws Exception {
        FileDataSource input = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.inPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSource)input).recordDelimiter('\n');
        input.setDegreeOfParallelism(this.config.getInteger("ReduceTest#NoSubtasks", 1));
        ReduceOperator testReducer = ReduceOperator.builder((ReduceFunction)new TestReducer(), StringValue.class, (int)0).build();
        testReducer.setDegreeOfParallelism(this.config.getInteger("ReduceTest#NoSubtasks", 1));
        testReducer.getParameters().setString("LOCAL_STRATEGY", this.config.getString("ReduceTest#LocalStrategy", ""));
        testReducer.getParameters().setString("INPUT_SHIP_STRATEGY", this.config.getString("ReduceTest#ShipStrategy", ""));
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setDegreeOfParallelism(1);
        output.setInput((Operator)testReducer);
        testReducer.setInput((Operator)input);
        Plan plan = new Plan((GenericDataSink)output);
        PactCompiler pc = new PactCompiler(new DataStatistics());
        OptimizedPlan op = pc.compile(plan);
        NepheleJobGraphGenerator jgg = new NepheleJobGraphGenerator();
        return jgg.compileJobGraph(op);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(RESULT, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        String[] localStrategies = new String[]{"LOCAL_STRATEGY_SORT"};
        String[] shipStrategies = new String[]{"SHIP_REPARTITION_HASH"};
        for (String localStrategy : localStrategies) {
            for (String shipStrategy : shipStrategies) {
                Configuration config = new Configuration();
                config.setString("ReduceTest#LocalStrategy", localStrategy);
                config.setString("ReduceTest#ShipStrategy", shipStrategy);
                config.setInteger("ReduceTest#NoSubtasks", 4);
                tConfigs.add(config);
            }
        }
        return ReduceITCase.toParameterList(tConfigs);
    }

    @ReduceOperator.Combinable
    public static class TestReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue reduceValue = new StringValue();
        private StringValue combineValue = new StringValue();

        public void combine(Iterator<Record> records, Collector<Record> out) throws Exception {
            int sum = 0;
            Record record = new Record();
            while (records.hasNext()) {
                record = records.next();
                this.combineValue = (StringValue)record.getField(1, (Value)this.combineValue);
                sum += Integer.parseInt(this.combineValue.toString());
                LOG.debug((Object)("Processed: [" + ((StringValue)record.getField(0, StringValue.class)).toString() + "," + this.combineValue.toString() + "]"));
            }
            this.combineValue.setValue((CharSequence)(sum + ""));
            record.setField(1, (Value)this.combineValue);
            out.collect((Object)record);
        }

        public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
            int sum = 0;
            Record record = new Record();
            while (records.hasNext()) {
                record = records.next();
                this.reduceValue = (StringValue)record.getField(1, (Value)this.reduceValue);
                sum += Integer.parseInt(this.reduceValue.toString());
                LOG.debug((Object)("Processed: [" + ((StringValue)record.getField(0, StringValue.class)).toString() + "," + this.reduceValue.toString() + "]"));
            }
            record.setField(1, (Value)new IntValue(sum));
            out.collect((Object)record);
        }
    }
}

