/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.operators;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.JoinFunction;
import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.api.java.record.operators.JoinOperator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.operators.io.ContractITCaseIOFormats;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JoinITCase
extends RecordAPITestBase {
    private static final Log LOG = LogFactory.getLog(JoinITCase.class);
    String leftInPath = null;
    String rightInPath = null;
    String resultPath = null;
    private static final String LEFT_IN = "1 1\n2 2\n3 3\n4 4\n1 2\n2 3\n3 4\n4 5\n1 3\n2 4\n3 5\n4 6\n1 4\n2 5\n3 6\n4 7\n";
    private static final String RIGHT_IN = "1 1\n2 2\n3 3\n5 1\n1 1\n2 2\n3 3\n6 1\n1 1\n2 2\n2 2\n7 1\n1 1\n2 2\n2 2\n8 1\n";
    private static final String RESULT = "2 1\n2 1\n2 1\n2 1\n2 2\n2 2\n2 2\n2 2\n2 3\n2 3\n2 3\n2 3\n2 4\n2 4\n2 4\n2 4\n4 1\n4 1\n4 2\n4 2\n4 3\n4 3\n4 4\n4 4\n3 1\n3 2\n3 3\n3 4\n3 1\n3 2\n3 3\n3 4\n3 1\n3 2\n3 3\n3 4\n3 1\n3 2\n3 3\n3 4\n3 1\n3 2\n3 3\n3 4\n3 1\n3 2\n3 3\n3 4\n";

    public JoinITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.leftInPath = this.createTempFile("left_in.txt", LEFT_IN);
        this.rightInPath = this.createTempFile("right_in.txt", RIGHT_IN);
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        FileDataSource input_left = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.leftInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSource)input_left).recordDelimiter('\n');
        input_left.setDegreeOfParallelism(this.config.getInteger("MatchTest#NoSubtasks", 1));
        FileDataSource input_right = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.rightInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSource)input_right).recordDelimiter('\n');
        input_right.setDegreeOfParallelism(this.config.getInteger("MatchTest#NoSubtasks", 1));
        JoinOperator testMatcher = JoinOperator.builder((JoinFunction)new TestMatcher(), StringValue.class, (int)0, (int)0).build();
        testMatcher.setDegreeOfParallelism(this.config.getInteger("MatchTest#NoSubtasks", 1));
        testMatcher.getParameters().setString("LOCAL_STRATEGY", this.config.getString("MatchTest#LocalStrategy", ""));
        if (this.config.getString("MatchTest#ShipStrategy", "").equals("BROADCAST_FIRST")) {
            testMatcher.getParameters().setString("INPUT_LEFT_SHIP_STRATEGY", "SHIP_BROADCAST");
            testMatcher.getParameters().setString("INPUT_RIGHT_SHIP_STRATEGY", "SHIP_FORWARD");
        } else if (this.config.getString("MatchTest#ShipStrategy", "").equals("BROADCAST_SECOND")) {
            testMatcher.getParameters().setString("INPUT_LEFT_SHIP_STRATEGY", "SHIP_FORWARD");
            testMatcher.getParameters().setString("INPUT_RIGHT_SHIP_STRATEGY", "SHIP_BROADCAST");
        } else {
            testMatcher.getParameters().setString("INPUT_SHIP_STRATEGY", this.config.getString("MatchTest#ShipStrategy", ""));
        }
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setDegreeOfParallelism(1);
        output.setInput((Operator)testMatcher);
        testMatcher.setFirstInput((Operator)input_left);
        testMatcher.setSecondInput((Operator)input_right);
        return new Plan((GenericDataSink)output);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(RESULT, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        String[] localStrategies = new String[]{"LOCAL_STRATEGY_SORT_BOTH_MERGE", "LOCAL_STRATEGY_HASH_BUILD_FIRST", "LOCAL_STRATEGY_HASH_BUILD_SECOND"};
        String[] shipStrategies = new String[]{"SHIP_REPARTITION_HASH", "BROADCAST_FIRST", "BROADCAST_SECOND"};
        for (String localStrategy : localStrategies) {
            for (String shipStrategy : shipStrategies) {
                Configuration config = new Configuration();
                config.setString("MatchTest#LocalStrategy", localStrategy);
                config.setString("MatchTest#ShipStrategy", shipStrategy);
                config.setInteger("MatchTest#NoSubtasks", 4);
                tConfigs.add(config);
            }
        }
        return JoinITCase.toParameterList(tConfigs);
    }

    public static class TestMatcher
    extends JoinFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue keyString = new StringValue();
        private StringValue valueString = new StringValue();

        public void join(Record value1, Record value2, Collector<Record> out) throws Exception {
            this.keyString = (StringValue)value1.getField(0, (Value)this.keyString);
            this.keyString.setValue((CharSequence)("" + (Integer.parseInt(this.keyString.getValue()) + 1)));
            value1.setField(0, (Value)this.keyString);
            this.valueString = (StringValue)value1.getField(1, (Value)this.valueString);
            int val1 = Integer.parseInt(this.valueString.getValue()) + 2;
            this.valueString = (StringValue)value2.getField(1, (Value)this.valueString);
            int val2 = Integer.parseInt(this.valueString.getValue()) + 1;
            value1.setField(1, (Value)new IntValue(val1 - val2));
            out.collect((Object)value1);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processed: [" + this.keyString.toString() + "," + val1 + "] + " + "[" + this.keyString.toString() + "," + val2 + "]"));
            }
        }
    }
}

