/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.operators;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.CrossFunction;
import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.api.java.record.operators.CrossOperator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.operators.io.ContractITCaseIOFormats;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CrossITCase
extends RecordAPITestBase {
    private static final Log LOG = LogFactory.getLog(CrossITCase.class);
    String leftInPath = null;
    String rightInPath = null;
    String resultPath = null;
    private static final String LEFT_IN = "1 1\n2 2\n1 1\n2 2\n3 3\n4 4\n3 3\n4 4\n";
    private static final String RIGHT_IN = "1 1\n1 2\n2 2\n2 4\n3 3\n3 6\n4 4\n4 8\n";
    private static final String RESULT = "4 1\n4 1\n4 2\n4 2\n5 2\n5 2\n5 4\n5 4\n6 3\n6 3\n7 4\n7 4\n5 0\n5 0\n5 1\n5 1\n6 1\n6 1\n6 3\n6 3\n7 2\n7 2\n8 3\n8 3\n6 -1\n6 -1\n6 0\n6 0\n7 0\n7 0\n8 1\n8 1\n7 -2\n7 -2\n7 -1\n7 -1\n8 -1\n8 -1\n";

    public CrossITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.leftInPath = this.createTempFile("left_in.txt", LEFT_IN);
        this.rightInPath = this.createTempFile("right_in.txt", RIGHT_IN);
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        FileDataSource input_left = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.leftInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSource)input_left).recordDelimiter('\n');
        input_left.setDegreeOfParallelism(this.config.getInteger("CrossTest#NoSubtasks", 1));
        FileDataSource input_right = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.rightInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSource)input_right).recordDelimiter('\n');
        input_right.setDegreeOfParallelism(this.config.getInteger("CrossTest#NoSubtasks", 1));
        CrossOperator testCross = CrossOperator.builder((CrossFunction)new TestCross()).build();
        testCross.setDegreeOfParallelism(this.config.getInteger("CrossTest#NoSubtasks", 1));
        testCross.getParameters().setString("LOCAL_STRATEGY", this.config.getString("CrossTest#LocalStrategy", ""));
        if (this.config.getString("CrossTest#ShipStrategy", "").equals("BROADCAST_FIRST")) {
            testCross.getParameters().setString("INPUT_LEFT_SHIP_STRATEGY", "SHIP_BROADCAST");
            testCross.getParameters().setString("INPUT_RIGHT_SHIP_STRATEGY", "SHIP_FORWARD");
        } else if (this.config.getString("CrossTest#ShipStrategy", "").equals("BROADCAST_SECOND")) {
            testCross.getParameters().setString("INPUT_LEFT_SHIP_STRATEGY", "SHIP_BROADCAST");
            testCross.getParameters().setString("INPUT_RIGHT_SHIP_STRATEGY", "SHIP_FORWARD");
        } else {
            testCross.getParameters().setString("INPUT_SHIP_STRATEGY", this.config.getString("CrossTest#ShipStrategy", ""));
        }
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setDegreeOfParallelism(1);
        output.setInput((Operator)testCross);
        testCross.setFirstInput((Operator)input_left);
        testCross.setSecondInput((Operator)input_right);
        return new Plan((GenericDataSink)output);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(RESULT, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        String[] localStrategies = new String[]{"LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_FIRST", "LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_SECOND", "LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_FIRST", "LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_SECOND"};
        String[] shipStrategies = new String[]{"BROADCAST_FIRST", "BROADCAST_SECOND"};
        for (String localStrategy : localStrategies) {
            for (String shipStrategy : shipStrategies) {
                Configuration config = new Configuration();
                config.setString("CrossTest#LocalStrategy", localStrategy);
                config.setString("CrossTest#ShipStrategy", shipStrategy);
                config.setInteger("CrossTest#NoSubtasks", 4);
                tConfigs.add(config);
            }
        }
        return CrossITCase.toParameterList(tConfigs);
    }

    public static class TestCross
    extends CrossFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue string = new StringValue();
        private IntValue integer = new IntValue();

        public void cross(Record record1, Record record2, Collector<Record> out) {
            this.string = (StringValue)record1.getField(1, (Value)this.string);
            int val1 = Integer.parseInt(this.string.toString());
            this.string = (StringValue)record2.getField(1, (Value)this.string);
            int val2 = Integer.parseInt(this.string.toString());
            this.string = (StringValue)record1.getField(0, (Value)this.string);
            int key1 = Integer.parseInt(this.string.toString());
            this.string = (StringValue)record2.getField(0, (Value)this.string);
            int key2 = Integer.parseInt(this.string.toString());
            LOG.debug((Object)("Processing { [" + key1 + "," + val1 + "] , [" + key2 + "," + val2 + "] }"));
            if (val1 + val2 <= 6) {
                this.string.setValue((CharSequence)(key1 + key2 + 2 + ""));
                this.integer.setValue(val2 - val1 + 1);
                record1.setField(0, (Value)this.string);
                record1.setField(1, (Value)this.integer);
                out.collect((Object)record1);
            }
        }
    }
}

