/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.operators;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.CoGroupFunction;
import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.api.java.record.io.FileOutputFormat;
import eu.stratosphere.api.java.record.operators.CoGroupOperator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CoGroupITCase
extends RecordAPITestBase {
    private static final Log LOG = LogFactory.getLog(CoGroupITCase.class);
    String leftInPath = null;
    String rightInPath = null;
    String resultPath = null;
    private static final String LEFT_IN = "1 1\n2 2\n3 3\n4 4\n1 2\n2 3\n3 4\n4 5\n1 3\n2 4\n3 5\n4 6\n1 4\n2 5\n3 6\n4 7\n";
    private static final String RIGHT_IN = "1 1\n2 2\n3 3\n5 1\n1 1\n2 2\n3 3\n6 1\n1 1\n2 2\n2 2\n7 1\n1 1\n2 2\n2 2\n8 1\n";
    private static final String RESULT = "1 6\n2 2\n3 12\n4 22\n5 -1\n6 -1\n7 -1\n8 -1\n";

    public CoGroupITCase(Configuration testConfig) {
        super(testConfig);
    }

    protected void preSubmit() throws Exception {
        this.leftInPath = this.createTempFile("left_in.txt", LEFT_IN);
        this.rightInPath = this.createTempFile("right_in.txt", RIGHT_IN);
        this.resultPath = this.getTempDirPath("result");
    }

    protected Plan getTestJob() {
        FileDataSource input_left = new FileDataSource((FileInputFormat)new CoGroupTestInFormat(), this.leftInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSource)input_left).recordDelimiter('\n');
        input_left.setDegreeOfParallelism(this.config.getInteger("CoGroupTest#NoSubtasks", 1));
        FileDataSource input_right = new FileDataSource((FileInputFormat)new CoGroupTestInFormat(), this.rightInPath);
        DelimitedInputFormat.configureDelimitedFormat((FileDataSource)input_right).recordDelimiter('\n');
        input_right.setDegreeOfParallelism(this.config.getInteger("CoGroupTest#NoSubtasks", 1));
        CoGroupOperator testCoGrouper = CoGroupOperator.builder((CoGroupFunction)new TestCoGrouper(), StringValue.class, (int)0, (int)0).build();
        testCoGrouper.setDegreeOfParallelism(this.config.getInteger("CoGroupTest#NoSubtasks", 1));
        testCoGrouper.getParameters().setString("LOCAL_STRATEGY", this.config.getString("CoGroupTest#LocalStrategy", ""));
        testCoGrouper.getParameters().setString("INPUT_SHIP_STRATEGY", this.config.getString("CoGroupTest#ShipStrategy", ""));
        FileDataSink output = new FileDataSink((eu.stratosphere.api.common.io.FileOutputFormat)new CoGroupOutFormat(), this.resultPath);
        output.setDegreeOfParallelism(1);
        output.setInput((Operator)testCoGrouper);
        testCoGrouper.setFirstInput((Operator)input_left);
        testCoGrouper.setSecondInput((Operator)input_right);
        return new Plan((GenericDataSink)output);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(RESULT, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        String[] localStrategies = new String[]{"LOCAL_STRATEGY_SORT_BOTH_MERGE"};
        String[] shipStrategies = new String[]{"SHIP_REPARTITION_HASH"};
        for (String localStrategy : localStrategies) {
            for (String shipStrategy : shipStrategies) {
                Configuration config = new Configuration();
                config.setString("CoGroupTest#LocalStrategy", localStrategy);
                config.setString("CoGroupTest#ShipStrategy", shipStrategy);
                config.setInteger("CoGroupTest#NoSubtasks", 4);
                tConfigs.add(config);
            }
        }
        return CoGroupITCase.toParameterList(tConfigs);
    }

    public static class TestCoGrouper
    extends CoGroupFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private StringValue keyString = new StringValue();
        private StringValue valueString = new StringValue();
        private Record record = new Record();

        public void coGroup(Iterator<Record> records1, Iterator<Record> records2, Collector<Record> out) {
            int sum = 0;
            LOG.debug((Object)"Start iterating over input1");
            while (records1.hasNext()) {
                this.record = records1.next();
                this.keyString = (StringValue)this.record.getField(0, (Value)this.keyString);
                this.valueString = (StringValue)this.record.getField(1, (Value)this.valueString);
                sum += Integer.parseInt(this.valueString.getValue());
                LOG.debug((Object)("Processed: [" + this.keyString.getValue() + "," + this.valueString.getValue() + "]"));
            }
            LOG.debug((Object)"Start iterating over input2");
            while (records2.hasNext()) {
                this.record = records2.next();
                this.keyString = (StringValue)this.record.getField(0, (Value)this.keyString);
                this.valueString = (StringValue)this.record.getField(1, (Value)this.valueString);
                sum -= Integer.parseInt(this.valueString.getValue());
                LOG.debug((Object)("Processed: [" + this.keyString.getValue() + "," + this.valueString.getValue() + "]"));
            }
            this.record.setField(1, (Value)new IntValue(sum));
            LOG.debug((Object)"Finished");
            out.collect((Object)this.record);
        }
    }

    public static class CoGroupOutFormat
    extends FileOutputFormat {
        private static final long serialVersionUID = 1L;
        private final StringBuilder buffer = new StringBuilder();
        private final StringValue keyString = new StringValue();
        private final IntValue valueInteger = new IntValue();

        public void writeRecord(Record record) throws IOException {
            this.buffer.setLength(0);
            this.buffer.append(((StringValue)record.getField(0, (Value)this.keyString)).toString());
            this.buffer.append(' ');
            this.buffer.append(((IntValue)record.getField(1, (Value)this.valueInteger)).getValue());
            this.buffer.append('\n');
            byte[] bytes = this.buffer.toString().getBytes();
            LOG.debug((Object)("Writing out: [" + this.keyString.toString() + "," + this.valueInteger.getValue() + "]"));
            this.stream.write(bytes);
        }
    }

    public static class CoGroupTestInFormat
    extends DelimitedInputFormat {
        private static final long serialVersionUID = 1L;
        private final StringValue keyString = new StringValue();
        private final StringValue valueString = new StringValue();

        public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
            this.keyString.setValueAscii(bytes, offset, 1);
            this.valueString.setValueAscii(bytes, offset + 2, 1);
            target.setField(0, (Value)this.keyString);
            target.setField(1, (Value)this.valueString);
            LOG.debug((Object)("Read in: [" + this.keyString.getValue() + "," + this.valueString.getValue() + "]"));
            return target;
        }
    }
}

