/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.javaApiOperators;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.functions.FilterFunction;
import eu.stratosphere.api.java.operators.FilterOperator;
import eu.stratosphere.api.java.operators.UnionOperator;
import eu.stratosphere.api.java.tuple.Tuple3;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.javaApiOperators.util.CollectionDataSets;
import eu.stratosphere.test.util.JavaProgramTestBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnionITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 3;
    private int curProgId;
    private String resultPath;
    private String expectedResult;

    public UnionITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = UnionProgs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.expectedResult, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return UnionITCase.toParameterList(tConfigs);
    }

    private static class UnionProgs {
        private static final String FULL_TUPLE_3_STRING = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";

        private UnionProgs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    UnionOperator unionDs = ds.union(CollectionDataSets.get3TupleDataSet(env));
                    unionDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    UnionOperator unionDs = ds.union(CollectionDataSets.get3TupleDataSet(env)).union(CollectionDataSets.get3TupleDataSet(env)).union(CollectionDataSets.get3TupleDataSet(env)).union(CollectionDataSets.get3TupleDataSet(env));
                    unionDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    FilterOperator empty = CollectionDataSets.get3TupleDataSet(env).filter((FilterFunction)new FilterFunction<Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public boolean filter(Tuple3<Integer, Long, String> value) throws Exception {
                            return false;
                        }
                    });
                    UnionOperator unionDs = CollectionDataSets.get3TupleDataSet(env).union((DataSet)empty);
                    unionDs.writeAsCsv(resultPath);
                    env.execute();
                    return FULL_TUPLE_3_STRING;
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

