/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.javaApiOperators;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.functions.MapFunction;
import eu.stratosphere.api.java.operators.MapOperator;
import eu.stratosphere.api.java.operators.SingleInputUdfOperator;
import eu.stratosphere.api.java.tuple.Tuple3;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.javaApiOperators.util.CollectionDataSets;
import eu.stratosphere.test.util.JavaProgramTestBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MapITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 9;
    private int curProgId;
    private String resultPath;
    private String expectedResult;

    public MapITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = MapProgs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.expectedResult, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return MapITCase.toParameterList(tConfigs);
    }

    private static class MapProgs {
        private MapProgs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
                    MapOperator identityMapDs = ds.map((MapFunction)new MapFunction<String, String>(){
                        private static final long serialVersionUID = 1L;

                        public String map(String value) throws Exception {
                            return value;
                        }
                    });
                    identityMapDs.writeAsText(resultPath);
                    env.execute();
                    return "Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nRandom comment\nLOL\n";
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    MapOperator identityMapDs = ds.map((MapFunction)new MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) throws Exception {
                            return value;
                        }
                    });
                    identityMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getCustomTypeDataSet(env);
                    MapOperator typeConversionMapDs = ds.map((MapFunction)new MapFunction<CollectionDataSets.CustomType, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;
                        private final Tuple3<Integer, Long, String> out = new Tuple3();

                        public Tuple3<Integer, Long, String> map(CollectionDataSets.CustomType value) throws Exception {
                            this.out.setField((Object)value.myInt, 0);
                            this.out.setField((Object)value.myLong, 1);
                            this.out.setField((Object)value.myString, 2);
                            return this.out;
                        }
                    });
                    typeConversionMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,0,Hi\n2,1,Hello\n2,2,Hello world\n3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n4,6,Comment#1\n4,7,Comment#2\n4,8,Comment#3\n4,9,Comment#4\n5,10,Comment#5\n5,11,Comment#6\n5,12,Comment#7\n5,13,Comment#8\n5,14,Comment#9\n6,15,Comment#10\n6,16,Comment#11\n6,17,Comment#12\n6,18,Comment#13\n6,19,Comment#14\n6,20,Comment#15\n";
                }
                case 4: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    MapOperator typeConversionMapDs = ds.map((MapFunction)new MapFunction<Tuple3<Integer, Long, String>, String>(){
                        private static final long serialVersionUID = 1L;

                        public String map(Tuple3<Integer, Long, String> value) throws Exception {
                            return (String)value.getField(2);
                        }
                    });
                    typeConversionMapDs.writeAsText(resultPath);
                    env.execute();
                    return "Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nComment#1\nComment#2\nComment#3\nComment#4\nComment#5\nComment#6\nComment#7\nComment#8\nComment#9\nComment#10\nComment#11\nComment#12\nComment#13\nComment#14\nComment#15\n";
                }
                case 5: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    MapOperator tupleMapDs = ds.map((MapFunction)new MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, String, Long>>(){
                        private static final long serialVersionUID = 1L;
                        private final Tuple3<Integer, String, Long> out = new Tuple3();

                        public Tuple3<Integer, String, Long> map(Tuple3<Integer, Long, String> value) throws Exception {
                            Integer incr = new Integer((Integer)value.f0 + 1);
                            this.out.setFields((Object)incr, value.f2, value.f1);
                            return this.out;
                        }
                    });
                    tupleMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "2,Hi,1\n3,Hello,2\n4,Hello world,2\n5,Hello world, how are you?,3\n6,I am fine.,3\n7,Luke Skywalker,3\n8,Comment#1,4\n9,Comment#2,4\n10,Comment#3,4\n11,Comment#4,4\n12,Comment#5,5\n13,Comment#6,5\n14,Comment#7,5\n15,Comment#8,5\n16,Comment#9,5\n17,Comment#10,6\n18,Comment#11,6\n19,Comment#12,6\n20,Comment#13,6\n21,Comment#14,6\n22,Comment#15,6\n";
                }
                case 6: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getCustomTypeDataSet(env);
                    MapOperator customMapDs = ds.map((MapFunction)new MapFunction<CollectionDataSets.CustomType, CollectionDataSets.CustomType>(){
                        private static final long serialVersionUID = 1L;
                        private final CollectionDataSets.CustomType out = new CollectionDataSets.CustomType();

                        public CollectionDataSets.CustomType map(CollectionDataSets.CustomType value) throws Exception {
                            this.out.myInt = value.myInt;
                            this.out.myLong = value.myLong;
                            this.out.myString = value.myString.toLowerCase();
                            return this.out;
                        }
                    });
                    customMapDs.writeAsText(resultPath);
                    env.execute();
                    return "1,0,hi\n2,1,hello\n2,2,hello world\n3,3,hello world, how are you?\n3,4,i am fine.\n3,5,luke skywalker\n4,6,comment#1\n4,7,comment#2\n4,8,comment#3\n4,9,comment#4\n5,10,comment#5\n5,11,comment#6\n5,12,comment#7\n5,13,comment#8\n5,14,comment#9\n6,15,comment#10\n6,16,comment#11\n6,17,comment#12\n6,18,comment#13\n6,19,comment#14\n6,20,comment#15\n";
                }
                case 7: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    MapOperator inputObjMapDs = ds.map((MapFunction)new MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) throws Exception {
                            Integer incr = new Integer((Integer)value.f0 + 1);
                            value.setField((Object)incr, 0);
                            return value;
                        }
                    });
                    inputObjMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "2,1,Hi\n3,2,Hello\n4,2,Hello world\n5,3,Hello world, how are you?\n6,3,I am fine.\n7,3,Luke Skywalker\n8,4,Comment#1\n9,4,Comment#2\n10,4,Comment#3\n11,4,Comment#4\n12,5,Comment#5\n13,5,Comment#6\n14,5,Comment#7\n15,5,Comment#8\n16,5,Comment#9\n17,6,Comment#10\n18,6,Comment#11\n19,6,Comment#12\n20,6,Comment#13\n21,6,Comment#14\n22,6,Comment#15\n";
                }
                case 8: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Integer> ints = CollectionDataSets.getIntegerDataSet(env);
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    SingleInputUdfOperator bcMapDs = ds.map((MapFunction)new MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;
                        private final Tuple3<Integer, Long, String> out = new Tuple3();
                        private Integer f2Replace = 0;

                        public void open(Configuration config) {
                            Collection ints = this.getRuntimeContext().getBroadcastVariable("ints");
                            int sum = 0;
                            for (Integer i : ints) {
                                sum += i.intValue();
                            }
                            this.f2Replace = sum;
                        }

                        public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) throws Exception {
                            this.out.setFields((Object)this.f2Replace, value.f1, value.f2);
                            return this.out;
                        }
                    }).withBroadcastSet(ints, "ints");
                    bcMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "55,1,Hi\n55,2,Hello\n55,2,Hello world\n55,3,Hello world, how are you?\n55,3,I am fine.\n55,3,Luke Skywalker\n55,4,Comment#1\n55,4,Comment#2\n55,4,Comment#3\n55,4,Comment#4\n55,5,Comment#5\n55,5,Comment#6\n55,5,Comment#7\n55,5,Comment#8\n55,5,Comment#9\n55,6,Comment#10\n55,6,Comment#11\n55,6,Comment#12\n55,6,Comment#13\n55,6,Comment#14\n55,6,Comment#15\n";
                }
                case 9: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    Configuration conf = new Configuration();
                    String testKey = "testVariable";
                    int testValue = 666;
                    conf.setInteger("testVariable", 666);
                    SingleInputUdfOperator bcMapDs = ds.map((MapFunction)new MapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public void open(Configuration config) {
                            int val = config.getInteger("testVariable", -1);
                            Assert.assertEquals((int)666, (int)val);
                        }

                        public Tuple3<Integer, Long, String> map(Tuple3<Integer, Long, String> value) {
                            return value;
                        }
                    }).withParameters(conf);
                    bcMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n2,2,Hello\n3,2,Hello world";
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

