/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.javaApiOperators;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.functions.JoinFunction;
import eu.stratosphere.api.java.functions.KeySelector;
import eu.stratosphere.api.java.operators.JoinOperator;
import eu.stratosphere.api.java.operators.TwoInputUdfOperator;
import eu.stratosphere.api.java.tuple.Tuple2;
import eu.stratosphere.api.java.tuple.Tuple3;
import eu.stratosphere.api.java.tuple.Tuple5;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.javaApiOperators.util.CollectionDataSets;
import eu.stratosphere.test.util.JavaProgramTestBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JoinITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 13;
    private int curProgId;
    private String resultPath;
    private String expectedResult;

    public JoinITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = JoinProgs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.expectedResult, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return JoinITCase.toParameterList(tConfigs);
    }

    public static class CustT3Join
    extends JoinFunction<CollectionDataSets.CustomType, Tuple3<Integer, Long, String>, Tuple2<String, String>> {
        public Tuple2<String, String> join(CollectionDataSets.CustomType first, Tuple3<Integer, Long, String> second) {
            return new Tuple2((Object)first.myString, second.f2);
        }
    }

    public static class T3CustJoin
    extends JoinFunction<Tuple3<Integer, Long, String>, CollectionDataSets.CustomType, Tuple2<String, String>> {
        public Tuple2<String, String> join(Tuple3<Integer, Long, String> first, CollectionDataSets.CustomType second) {
            return new Tuple2(first.f2, (Object)second.myString);
        }
    }

    public static class T3T5BCJoin
    extends JoinFunction<Tuple3<Integer, Long, String>, Tuple5<Integer, Long, Integer, String, Long>, Tuple3<String, String, Integer>> {
        private int broadcast;

        public void open(Configuration config) {
            Collection ints = this.getRuntimeContext().getBroadcastVariable("ints");
            int sum = 0;
            for (Integer i : ints) {
                sum += i.intValue();
            }
            this.broadcast = sum;
        }

        public Tuple3<String, String, Integer> join(Tuple3<Integer, Long, String> first, Tuple5<Integer, Long, Integer, String, Long> second) {
            return new Tuple3(first.f2, second.f3, (Object)this.broadcast);
        }
    }

    public static class RightReturningJoin
    extends JoinFunction<Tuple3<Integer, Long, String>, Tuple5<Integer, Long, Integer, String, Long>, Tuple5<Integer, Long, Integer, String, Long>> {
        public Tuple5<Integer, Long, Integer, String, Long> join(Tuple3<Integer, Long, String> first, Tuple5<Integer, Long, Integer, String, Long> second) {
            return second;
        }
    }

    public static class LeftReturningJoin
    extends JoinFunction<Tuple3<Integer, Long, String>, Tuple5<Integer, Long, Integer, String, Long>, Tuple3<Integer, Long, String>> {
        public Tuple3<Integer, Long, String> join(Tuple3<Integer, Long, String> first, Tuple5<Integer, Long, Integer, String, Long> second) {
            return first;
        }
    }

    public static class T3T5Join
    extends JoinFunction<Tuple3<Integer, Long, String>, Tuple5<Integer, Long, Integer, String, Long>, Tuple2<String, String>> {
        public Tuple2<String, String> join(Tuple3<Integer, Long, String> first, Tuple5<Integer, Long, Integer, String, Long> second) {
            return new Tuple2(first.f2, second.f3);
        }
    }

    private static class JoinProgs {
        private JoinProgs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.EquiJoin joinDs = ds1.join(ds2).where(new int[]{1}).equalTo(new int[]{1}).with((JoinFunction)new T3T5Join());
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.get3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.EquiJoin joinDs = ds1.join(ds2).where(new int[]{0, 1}).equalTo(new int[]{0, 4}).with((JoinFunction)new T3T5Join());
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt wie gehts?\nHello world,ABC\nI am fine.,HIJ\nI am fine.,IJK\n";
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.DefaultJoin joinDs = ds1.join(ds2).where(new int[]{0}).equalTo(new int[]{2});
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "(1, 1, Hi),(2, 2, 1, Hallo Welt, 2)\n(2, 2, Hello),(2, 3, 2, Hallo Welt wie, 1)\n(3, 2, Hello world),(3, 4, 3, Hallo Welt wie gehts?, 2)\n";
                }
                case 4: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.EquiJoin joinDs = ds1.joinWithHuge(ds2).where(new int[]{1}).equalTo(new int[]{1}).with((JoinFunction)new T3T5Join());
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
                }
                case 5: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.EquiJoin joinDs = ds1.joinWithTiny(ds2).where(new int[]{1}).equalTo(new int[]{1}).with((JoinFunction)new T3T5Join());
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,Hallo\nHello,Hallo Welt\nHello world,Hallo Welt\n";
                }
                case 6: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.EquiJoin joinDs = ds1.join(ds2).where(new int[]{1}).equalTo(new int[]{1}).with((JoinFunction)new LeftReturningJoin());
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n2,2,Hello\n3,2,Hello world\n";
                }
                case 7: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.EquiJoin joinDs = ds1.join(ds2).where(new int[]{1}).equalTo(new int[]{1}).with((JoinFunction)new RightReturningJoin());
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,0,Hallo,1\n2,2,1,Hallo Welt,2\n2,2,1,Hallo Welt,2\n";
                }
                case 8: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Integer> intDs = CollectionDataSets.getIntegerDataSet(env);
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.get3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    TwoInputUdfOperator joinDs = ds1.join(ds2).where(new int[]{1}).equalTo(new int[]{4}).with((JoinFunction)new T3T5BCJoin()).withBroadcastSet(intDs, "ints");
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,Hallo,55\nHi,Hallo Welt wie,55\nHello,Hallo Welt,55\nHello world,Hallo Welt,55\n";
                }
                case 9: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<CollectionDataSets.CustomType> ds1 = CollectionDataSets.getSmallCustomTypeDataSet(env);
                    DataSet<Tuple3<Integer, Long, String>> ds2 = CollectionDataSets.get3TupleDataSet(env);
                    JoinOperator.EquiJoin joinDs = ds1.join(ds2).where((KeySelector)new KeySelector<CollectionDataSets.CustomType, Integer>(){

                        public Integer getKey(CollectionDataSets.CustomType value) {
                            return value.myInt;
                        }
                    }).equalTo(new int[]{0}).with((JoinFunction)new CustT3Join());
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,Hi\nHello,Hello\nHello world,Hello\n";
                }
                case 10: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.ProjectJoin joinDs = ds1.join(ds2).where(new int[]{1}).equalTo(new int[]{1}).projectFirst(new int[]{2, 1}).projectSecond(new int[]{3}).projectFirst(new int[]{0}).projectSecond(new int[]{4, 1}).types(String.class, Long.class, String.class, Integer.class, Long.class, Long.class);
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,1,Hallo,1,1,1\nHello,2,Hallo Welt,2,2,2\nHello world,2,Hallo Welt,3,2,2\n";
                }
                case 11: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.get5TupleDataSet(env);
                    JoinOperator.ProjectJoin joinDs = ds1.join(ds2).where(new int[]{1}).equalTo(new int[]{1}).projectSecond(new int[]{3}).projectFirst(new int[]{2, 1}).projectSecond(new int[]{4, 1}).projectFirst(new int[]{0}).types(String.class, String.class, Long.class, Long.class, Long.class, Integer.class);
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hallo,Hi,1,1,1,1\nHallo Welt,Hello,2,2,2,2\nHallo Welt,Hello world,2,2,2,3\n";
                }
                case 12: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds1 = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<CollectionDataSets.CustomType> ds2 = CollectionDataSets.getCustomTypeDataSet(env);
                    JoinOperator.EquiJoin joinDs = ds1.join(ds2).where(new int[]{1}).equalTo((KeySelector)new KeySelector<CollectionDataSets.CustomType, Long>(){

                        public Long getKey(CollectionDataSets.CustomType value) {
                            return value.myLong;
                        }
                    }).with((JoinFunction)new T3CustJoin());
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,Hello\nHello,Hello world\nHello world,Hello world\n";
                }
                case 13: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<CollectionDataSets.CustomType> ds1 = CollectionDataSets.getCustomTypeDataSet(env);
                    DataSet<CollectionDataSets.CustomType> ds2 = CollectionDataSets.getSmallCustomTypeDataSet(env);
                    JoinOperator.DefaultJoin joinDs = ds1.join(ds2).where((KeySelector)new KeySelector<CollectionDataSets.CustomType, Integer>(){

                        public Integer getKey(CollectionDataSets.CustomType value) {
                            return value.myInt;
                        }
                    }).equalTo((KeySelector)new KeySelector<CollectionDataSets.CustomType, Integer>(){

                        public Integer getKey(CollectionDataSets.CustomType value) {
                            return value.myInt;
                        }
                    });
                    joinDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,0,Hi,1,0,Hi\n2,1,Hello,2,1,Hello\n2,1,Hello,2,2,Hello world\n2,2,Hello world,2,1,Hello\n2,2,Hello world,2,2,Hello world\n";
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

