/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.javaApiOperators;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.functions.FlatMapFunction;
import eu.stratosphere.api.java.operators.FlatMapOperator;
import eu.stratosphere.api.java.operators.SingleInputUdfOperator;
import eu.stratosphere.api.java.tuple.Tuple3;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.javaApiOperators.util.CollectionDataSets;
import eu.stratosphere.test.util.JavaProgramTestBase;
import eu.stratosphere.util.Collector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FlatMapITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 7;
    private int curProgId;
    private String resultPath;
    private String expectedResult;

    public FlatMapITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = FlatMapProgs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.expectedResult, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return FlatMapITCase.toParameterList(tConfigs);
    }

    private static class FlatMapProgs {
        private FlatMapProgs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
                    FlatMapOperator nonPassingFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){
                        private static final long serialVersionUID = 1L;

                        public void flatMap(String value, Collector<String> out) throws Exception {
                            if (value.contains("bananas")) {
                                out.collect((Object)value);
                            }
                        }
                    });
                    nonPassingFlatMapDs.writeAsText(resultPath);
                    env.execute();
                    return "\n";
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
                    FlatMapOperator duplicatingFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){
                        private static final long serialVersionUID = 1L;

                        public void flatMap(String value, Collector<String> out) throws Exception {
                            out.collect((Object)value);
                            out.collect((Object)value.toUpperCase());
                        }
                    });
                    duplicatingFlatMapDs.writeAsText(resultPath);
                    env.execute();
                    return "Hi\nHI\nHello\nHELLO\nHello world\nHELLO WORLD\nHello world, how are you?\nHELLO WORLD, HOW ARE YOU?\nI am fine.\nI AM FINE.\nLuke Skywalker\nLUKE SKYWALKER\nRandom comment\nRANDOM COMMENT\nLOL\nLOL\n";
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    FlatMapOperator varyingTuplesMapDs = ds.flatMap((FlatMapFunction)new FlatMapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public void flatMap(Tuple3<Integer, Long, String> value, Collector<Tuple3<Integer, Long, String>> out) throws Exception {
                            int numTuples = (Integer)value.f0 % 3;
                            for (int i = 0; i < numTuples; ++i) {
                                out.collect(value);
                            }
                        }
                    });
                    varyingTuplesMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n2,2,Hello\n2,2,Hello\n4,3,Hello world, how are you?\n5,3,I am fine.\n5,3,I am fine.\n7,4,Comment#1\n8,4,Comment#2\n8,4,Comment#2\n10,4,Comment#4\n11,5,Comment#5\n11,5,Comment#5\n13,5,Comment#7\n14,5,Comment#8\n14,5,Comment#8\n16,6,Comment#10\n17,6,Comment#11\n17,6,Comment#11\n19,6,Comment#13\n20,6,Comment#14\n20,6,Comment#14\n";
                }
                case 4: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getCustomTypeDataSet(env);
                    FlatMapOperator typeConversionFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapFunction<CollectionDataSets.CustomType, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;
                        private final Tuple3<Integer, Long, String> outTuple = new Tuple3();

                        public void flatMap(CollectionDataSets.CustomType value, Collector<Tuple3<Integer, Long, String>> out) throws Exception {
                            this.outTuple.setField((Object)value.myInt, 0);
                            this.outTuple.setField((Object)value.myLong, 1);
                            this.outTuple.setField((Object)value.myString, 2);
                            out.collect(this.outTuple);
                        }
                    });
                    typeConversionFlatMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,0,Hi\n2,1,Hello\n2,2,Hello world\n3,3,Hello world, how are you?\n3,4,I am fine.\n3,5,Luke Skywalker\n4,6,Comment#1\n4,7,Comment#2\n4,8,Comment#3\n4,9,Comment#4\n5,10,Comment#5\n5,11,Comment#6\n5,12,Comment#7\n5,13,Comment#8\n5,14,Comment#9\n6,15,Comment#10\n6,16,Comment#11\n6,17,Comment#12\n6,18,Comment#13\n6,19,Comment#14\n6,20,Comment#15\n";
                }
                case 5: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    FlatMapOperator typeConversionFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapFunction<Tuple3<Integer, Long, String>, String>(){
                        private static final long serialVersionUID = 1L;

                        public void flatMap(Tuple3<Integer, Long, String> value, Collector<String> out) throws Exception {
                            out.collect(value.f2);
                        }
                    });
                    typeConversionFlatMapDs.writeAsText(resultPath);
                    env.execute();
                    return "Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nComment#1\nComment#2\nComment#3\nComment#4\nComment#5\nComment#6\nComment#7\nComment#8\nComment#9\nComment#10\nComment#11\nComment#12\nComment#13\nComment#14\nComment#15\n";
                }
                case 6: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    FlatMapOperator inputObjFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;

                        public void flatMap(Tuple3<Integer, Long, String> value, Collector<Tuple3<Integer, Long, String>> out) throws Exception {
                            int numTuples = (Integer)value.f0 % 4;
                            for (int i = 0; i < numTuples; ++i) {
                                value.setField((Object)i, 0);
                                out.collect(value);
                            }
                        }
                    });
                    inputObjFlatMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "0,1,Hi\n0,2,Hello\n1,2,Hello\n0,2,Hello world\n1,2,Hello world\n2,2,Hello world\n0,3,I am fine.\n0,3,Luke Skywalker\n1,3,Luke Skywalker\n0,4,Comment#1\n1,4,Comment#1\n2,4,Comment#1\n0,4,Comment#3\n0,4,Comment#4\n1,4,Comment#4\n0,5,Comment#5\n1,5,Comment#5\n2,5,Comment#5\n0,5,Comment#7\n0,5,Comment#8\n1,5,Comment#8\n0,5,Comment#9\n1,5,Comment#9\n2,5,Comment#9\n0,6,Comment#11\n0,6,Comment#12\n1,6,Comment#12\n0,6,Comment#13\n1,6,Comment#13\n2,6,Comment#13\n0,6,Comment#15\n";
                }
                case 7: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Integer> ints = CollectionDataSets.getIntegerDataSet(env);
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
                    SingleInputUdfOperator bcFlatMapDs = ds.flatMap((FlatMapFunction)new FlatMapFunction<Tuple3<Integer, Long, String>, Tuple3<Integer, Long, String>>(){
                        private static final long serialVersionUID = 1L;
                        private final Tuple3<Integer, Long, String> outTuple = new Tuple3();
                        private Integer f2Replace = 0;

                        public void open(Configuration config) {
                            Collection ints = this.getRuntimeContext().getBroadcastVariable("ints");
                            int sum = 0;
                            for (Integer i : ints) {
                                sum += i.intValue();
                            }
                            this.f2Replace = sum;
                        }

                        public void flatMap(Tuple3<Integer, Long, String> value, Collector<Tuple3<Integer, Long, String>> out) throws Exception {
                            this.outTuple.setFields((Object)this.f2Replace, value.f1, value.f2);
                            out.collect(this.outTuple);
                        }
                    }).withBroadcastSet(ints, "ints");
                    bcFlatMapDs.writeAsCsv(resultPath);
                    env.execute();
                    return "55,1,Hi\n55,2,Hello\n55,2,Hello world\n55,3,Hello world, how are you?\n55,3,I am fine.\n55,3,Luke Skywalker\n55,4,Comment#1\n55,4,Comment#2\n55,4,Comment#3\n55,4,Comment#4\n55,5,Comment#5\n55,5,Comment#6\n55,5,Comment#7\n55,5,Comment#8\n55,5,Comment#9\n55,6,Comment#10\n55,6,Comment#11\n55,6,Comment#12\n55,6,Comment#13\n55,6,Comment#14\n55,6,Comment#15\n";
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

