/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.javaApiOperators;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.functions.CrossFunction;
import eu.stratosphere.api.java.operators.CrossOperator;
import eu.stratosphere.api.java.operators.TwoInputUdfOperator;
import eu.stratosphere.api.java.tuple.Tuple2;
import eu.stratosphere.api.java.tuple.Tuple3;
import eu.stratosphere.api.java.tuple.Tuple5;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.javaApiOperators.util.CollectionDataSets;
import eu.stratosphere.test.util.JavaProgramTestBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CrossITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 11;
    private int curProgId;
    private String resultPath;
    private String expectedResult;

    public CrossITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = CrossProgs.runProgram(this.curProgId, this.resultPath);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(this.expectedResult, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return CrossITCase.toParameterList(tConfigs);
    }

    public static class Tuple5CrossBC
    extends CrossFunction<Tuple5<Integer, Long, Integer, String, Long>, Tuple5<Integer, Long, Integer, String, Long>, Tuple3<Integer, Integer, Integer>> {
        private static final long serialVersionUID = 1L;
        private int broadcast = 42;

        public void open(Configuration config) {
            Collection ints = this.getRuntimeContext().getBroadcastVariable("ints");
            int sum = 0;
            for (Integer i : ints) {
                sum += i.intValue();
            }
            this.broadcast = sum;
        }

        public Tuple3<Integer, Integer, Integer> cross(Tuple5<Integer, Long, Integer, String, Long> first, Tuple5<Integer, Long, Integer, String, Long> second) throws Exception {
            return new Tuple3((Object)((Integer)first.f0 + (Integer)second.f0), (Object)((Integer)first.f2 * (Integer)second.f2), (Object)this.broadcast);
        }
    }

    public static class Tuple5ReturnRight
    extends CrossFunction<Tuple3<Integer, Long, String>, Tuple5<Integer, Long, Integer, String, Long>, Tuple5<Integer, Long, Integer, String, Long>> {
        private static final long serialVersionUID = 1L;

        public Tuple5<Integer, Long, Integer, String, Long> cross(Tuple3<Integer, Long, String> first, Tuple5<Integer, Long, Integer, String, Long> second) throws Exception {
            return second;
        }
    }

    public static class Tuple3ReturnLeft
    extends CrossFunction<Tuple3<Integer, Long, String>, Tuple5<Integer, Long, Integer, String, Long>, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;

        public Tuple3<Integer, Long, String> cross(Tuple3<Integer, Long, String> first, Tuple5<Integer, Long, Integer, String, Long> second) throws Exception {
            return first;
        }
    }

    public static class MixedCross
    extends CrossFunction<Tuple5<Integer, Long, Integer, String, Long>, CollectionDataSets.CustomType, Tuple3<Integer, Long, String>> {
        private static final long serialVersionUID = 1L;

        public Tuple3<Integer, Long, String> cross(Tuple5<Integer, Long, Integer, String, Long> first, CollectionDataSets.CustomType second) throws Exception {
            return new Tuple3((Object)((Integer)first.f0 + second.myInt), (Object)((long)((Integer)first.f2).intValue() * second.myLong), (Object)((String)first.f3 + second.myString));
        }
    }

    public static class CustomTypeCross
    extends CrossFunction<CollectionDataSets.CustomType, CollectionDataSets.CustomType, CollectionDataSets.CustomType> {
        private static final long serialVersionUID = 1L;

        public CollectionDataSets.CustomType cross(CollectionDataSets.CustomType first, CollectionDataSets.CustomType second) throws Exception {
            return new CollectionDataSets.CustomType(first.myInt * second.myInt, first.myLong + second.myLong, first.myString + second.myString);
        }
    }

    public static class Tuple5Cross
    extends CrossFunction<Tuple5<Integer, Long, Integer, String, Long>, Tuple5<Integer, Long, Integer, String, Long>, Tuple2<Integer, String>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<Integer, String> cross(Tuple5<Integer, Long, Integer, String, Long> first, Tuple5<Integer, Long, Integer, String, Long> second) throws Exception {
            return new Tuple2((Object)((Integer)first.f2 + (Integer)second.f2), (Object)((String)first.f3 + (String)second.f3));
        }
    }

    private static class CrossProgs {
        private CrossProgs() {
        }

        public static String runProgram(int progId, String resultPath) throws Exception {
            switch (progId) {
                case 1: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.getSmall5TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    CrossOperator crossDs = ds.cross(ds2).with((CrossFunction)new Tuple5Cross());
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "0,HalloHallo\n1,HalloHallo Welt\n2,HalloHallo Welt wie\n1,Hallo WeltHallo\n2,Hallo WeltHallo Welt\n3,Hallo WeltHallo Welt wie\n2,Hallo Welt wieHallo\n3,Hallo Welt wieHallo Welt\n4,Hallo Welt wieHallo Welt wie\n";
                }
                case 2: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    CrossOperator crossDs = ds.cross(ds2).with((CrossFunction)new Tuple3ReturnLeft());
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,Hi\n1,1,Hi\n1,1,Hi\n2,2,Hello\n2,2,Hello\n2,2,Hello\n3,2,Hello world\n3,2,Hello world\n3,2,Hello world\n";
                }
                case 3: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    CrossOperator crossDs = ds.cross(ds2).with((CrossFunction)new Tuple5ReturnRight());
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "1,1,0,Hallo,1\n1,1,0,Hallo,1\n1,1,0,Hallo,1\n2,2,1,Hallo Welt,2\n2,2,1,Hallo Welt,2\n2,2,1,Hallo Welt,2\n2,3,2,Hallo Welt wie,1\n2,3,2,Hallo Welt wie,1\n2,3,2,Hallo Welt wie,1\n";
                }
                case 4: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Integer> intDs = CollectionDataSets.getIntegerDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.getSmall5TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    TwoInputUdfOperator crossDs = ds.cross(ds2).with((CrossFunction)new Tuple5CrossBC()).withBroadcastSet(intDs, "ints");
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "2,0,55\n3,0,55\n3,0,55\n3,0,55\n4,1,55\n4,2,55\n3,0,55\n4,2,55\n4,4,55\n";
                }
                case 5: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.getSmall5TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    CrossOperator crossDs = ds.crossWithHuge(ds2).with((CrossFunction)new Tuple5Cross());
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "0,HalloHallo\n1,HalloHallo Welt\n2,HalloHallo Welt wie\n1,Hallo WeltHallo\n2,Hallo WeltHallo Welt\n3,Hallo WeltHallo Welt wie\n2,Hallo Welt wieHallo\n3,Hallo Welt wieHallo Welt\n4,Hallo Welt wieHallo Welt wie\n";
                }
                case 6: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.getSmall5TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    CrossOperator crossDs = ds.crossWithTiny(ds2).with((CrossFunction)new Tuple5Cross());
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "0,HalloHallo\n1,HalloHallo Welt\n2,HalloHallo Welt wie\n1,Hallo WeltHallo\n2,Hallo WeltHallo Welt\n3,Hallo WeltHallo Welt wie\n2,Hallo Welt wieHallo\n3,Hallo Welt wieHallo Welt\n4,Hallo Welt wieHallo Welt wie\n";
                }
                case 7: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    CrossOperator.ProjectCross crossDs = ds.cross(ds2).projectFirst(new int[]{2, 1}).projectSecond(new int[]{3}).projectFirst(new int[]{0}).projectSecond(new int[]{4, 1}).types(String.class, Long.class, String.class, Integer.class, Long.class, Long.class);
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hi,1,Hallo,1,1,1\nHi,1,Hallo Welt,1,2,2\nHi,1,Hallo Welt wie,1,1,3\nHello,2,Hallo,2,1,1\nHello,2,Hallo Welt,2,2,2\nHello,2,Hallo Welt wie,2,1,3\nHello world,2,Hallo,3,1,1\nHello world,2,Hallo Welt,3,2,2\nHello world,2,Hallo Welt wie,3,1,3\n";
                }
                case 8: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    CrossOperator.ProjectCross crossDs = ds.cross(ds2).projectSecond(new int[]{3}).projectFirst(new int[]{2, 1}).projectSecond(new int[]{4, 1}).projectFirst(new int[]{0}).types(String.class, String.class, Long.class, Long.class, Long.class, Integer.class);
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "Hallo,Hi,1,1,1,1\nHallo Welt,Hi,1,2,2,1\nHallo Welt wie,Hi,1,1,3,1\nHallo,Hello,2,1,1,2\nHallo Welt,Hello,2,2,2,2\nHallo Welt wie,Hello,2,1,3,2\nHallo,Hello world,2,1,1,3\nHallo Welt,Hello world,2,2,2,3\nHallo Welt wie,Hello world,2,1,3,3\n";
                }
                case 9: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.getSmall3TupleDataSet(env);
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds2 = CollectionDataSets.getSmall5TupleDataSet(env);
                    CrossOperator.DefaultCross crossDs = ds.cross(ds2);
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "(1, 1, Hi),(2, 2, 1, Hallo Welt, 2)\n(1, 1, Hi),(1, 1, 0, Hallo, 1)\n(1, 1, Hi),(2, 3, 2, Hallo Welt wie, 1)\n(2, 2, Hello),(2, 2, 1, Hallo Welt, 2)\n(2, 2, Hello),(1, 1, 0, Hallo, 1)\n(2, 2, Hello),(2, 3, 2, Hallo Welt wie, 1)\n(3, 2, Hello world),(2, 2, 1, Hallo Welt, 2)\n(3, 2, Hello world),(1, 1, 0, Hallo, 1)\n(3, 2, Hello world),(2, 3, 2, Hallo Welt wie, 1)\n";
                }
                case 10: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets.getSmallCustomTypeDataSet(env);
                    DataSet<CollectionDataSets.CustomType> ds2 = CollectionDataSets.getSmallCustomTypeDataSet(env);
                    CrossOperator crossDs = ds.cross(ds2).with((CrossFunction)new CustomTypeCross());
                    crossDs.writeAsText(resultPath);
                    env.execute();
                    return "1,0,HiHi\n2,1,HiHello\n2,2,HiHello world\n2,1,HelloHi\n4,2,HelloHello\n4,3,HelloHello world\n2,2,Hello worldHi\n4,3,Hello worldHello\n4,4,Hello worldHello world";
                }
                case 11: {
                    ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
                    DataSet<Tuple5<Integer, Long, Integer, String, Long>> ds = CollectionDataSets.getSmall5TupleDataSet(env);
                    DataSet<CollectionDataSets.CustomType> ds2 = CollectionDataSets.getSmallCustomTypeDataSet(env);
                    CrossOperator crossDs = ds.cross(ds2).with((CrossFunction)new MixedCross());
                    crossDs.writeAsCsv(resultPath);
                    env.execute();
                    return "2,0,HalloHi\n3,0,HalloHello\n3,0,HalloHello world\n3,0,Hallo WeltHi\n4,1,Hallo WeltHello\n4,2,Hallo WeltHello world\n3,0,Hallo Welt wieHi\n4,2,Hallo Welt wieHello\n4,4,Hallo Welt wieHello world\n";
                }
            }
            throw new IllegalArgumentException("Invalid program id");
        }
    }
}

