/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative.nephele.danglingpagerank;

import eu.stratosphere.api.common.aggregators.ConvergenceCriterion;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.PageRankStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DiffL1NormConvergenceCriterion
implements ConvergenceCriterion<PageRankStats> {
    private static final double EPSILON = 5.0E-5;
    private static final Log log = LogFactory.getLog(DiffL1NormConvergenceCriterion.class);

    public boolean isConverged(int iteration, PageRankStats pageRankStats) {
        double diff = pageRankStats.diff();
        if (log.isInfoEnabled()) {
            log.info((Object)("Stats in iteration [" + iteration + "]: " + pageRankStats));
            log.info((Object)("L1 norm of the vector difference is [" + diff + "] in iteration [" + iteration + "]"));
        }
        return diff < 5.0E-5;
    }
}

