/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative.nephele.danglingpagerank;

import eu.stratosphere.api.java.record.io.TextInputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.iterative.nephele.ConfigUtils;
import eu.stratosphere.test.iterative.nephele.danglingpagerank.BooleanValue;
import eu.stratosphere.types.DoubleValue;
import eu.stratosphere.types.LongValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import java.util.regex.Pattern;

public class DanglingPageGenerateRankInputFormat
extends TextInputFormat {
    private static final long serialVersionUID = 1L;
    private DoubleValue initialRank;
    private static final Pattern SEPARATOR = Pattern.compile("[, \t]");

    public void configure(Configuration parameters) {
        long numVertices = ConfigUtils.asLong("pageRank.numVertices", parameters);
        this.initialRank = new DoubleValue(1.0 / (double)numVertices);
        super.configure(parameters);
    }

    public Record readRecord(Record target, byte[] bytes, int offset, int numBytes) {
        String str = new String(bytes, offset, numBytes);
        String[] tokens = SEPARATOR.split(str);
        long vertexID = Long.parseLong(tokens[0]);
        boolean isDangling = tokens.length > 1 && Integer.parseInt(tokens[1]) == 1;
        target.clear();
        target.addField((Value)new LongValue(vertexID));
        target.addField((Value)this.initialRank);
        target.addField((Value)new BooleanValue(isDangling));
        return target;
    }
}

