/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative.nephele.danglingpagerank;

import com.google.common.base.Charsets;
import java.io.Serializable;

public class AsciiLongArrayView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] buffer;
    private int offset;
    private int numBytes;
    private int tokenOffset;
    private int tokenNumBytes;
    private static final int NOT_SET = -1;
    private static final int RADIX_TEN = 10;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;

    public void set(byte[] buffer, int offset, int numBytes) {
        this.buffer = buffer;
        this.offset = offset;
        this.numBytes = numBytes;
        this.tokenOffset = -1;
        this.checkForSingleTrailingWhitespace();
    }

    private void checkForSingleTrailingWhitespace() {
        if (Character.isWhitespace((char)this.buffer[this.offset + this.numBytes - 1])) {
            --this.numBytes;
        }
    }

    public int numElements() {
        int matches = 0;
        for (int pos = this.offset; pos < this.offset + this.numBytes; ++pos) {
            if (!Character.isWhitespace((char)this.buffer[pos])) continue;
            ++matches;
        }
        return matches + 1;
    }

    public boolean next() {
        int candidatePos;
        if (this.tokenOffset == -1) {
            this.tokenOffset = this.offset;
        } else {
            this.tokenOffset += this.tokenNumBytes + 1;
            if (this.tokenOffset > this.offset + this.numBytes) {
                return false;
            }
        }
        this.tokenNumBytes = 1;
        while ((candidatePos = this.tokenOffset + this.tokenNumBytes) < this.offset + this.numBytes && !Character.isWhitespace((char)this.buffer[candidatePos])) {
            ++this.tokenNumBytes;
        }
        return true;
    }

    private char tokenCharAt(int pos) {
        return (char)this.buffer[this.tokenOffset + pos];
    }

    public long element() {
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = this.tokenNumBytes;
        if (max > 0) {
            int digit;
            long multmin;
            long limit;
            if (this.tokenCharAt(0) == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
            if (i < max) {
                if ((digit = Character.digit(this.tokenCharAt(i++), 10)) < 0) {
                    throw new NumberFormatException(this.toString());
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(this.tokenCharAt(i++), 10)) < 0) {
                    throw new NumberFormatException(this.toString());
                }
                if (result < multmin) {
                    throw new NumberFormatException(this.toString());
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException(this.toString());
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException(this.toString());
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(this.toString());
        }
        return -result;
    }

    public String toString() {
        return "[" + new String(this.buffer, this.offset, this.numBytes, Charsets.US_ASCII) + "] (buffer length: " + this.buffer.length + ", offset: " + this.offset + ", numBytes: " + this.numBytes + ")";
    }
}

