/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.recordJobs.graph.SimplePageRank;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PageRankITCase
extends RecordAPITestBase {
    private static final String VERTICES = "1\n2\n3\n4\n5\n6\n7\n8\n9\n10\n";
    private static final String EDGES = "1 2\n2 3\n3 4\n4 5\n5 6\n6 7\n7 8\n8 9\n9 10\n10 1\n";
    protected String pagesPath;
    protected String edgesPath;
    protected String resultPath;

    public PageRankITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.pagesPath = this.createTempFile("pages.txt", VERTICES);
        this.edgesPath = this.createTempFile("edges.txt", EDGES);
        this.resultPath = this.getTempFilePath("results");
    }

    protected Plan getTestJob() {
        SimplePageRank pr = new SimplePageRank();
        Plan plan = pr.getPlan(this.config.getString("NumSubtasks", "1"), this.pagesPath, this.edgesPath, this.resultPath, this.config.getString("NumIterations", "5"), "10");
        return plan;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config1 = new Configuration();
        config1.setInteger("NumSubtasks", 4);
        config1.setString("NumIterations", "5");
        return PageRankITCase.toParameterList((Configuration[])new Configuration[]{config1});
    }
}

