/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.scala.ScalaPlan;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.examples.scala.graph.LineRank;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LineRankITCase
extends RecordAPITestBase {
    private static final String SOURCE_INCIDENCE = "1,1,1\n2,1,1\n3,1,1\n4,2,1\n5,3,1\n6,3,1\n7,4,1\n8,4,1\n9,5,1\n";
    private static final String TARGET_INCIDENCE = "1,2,1\n2,3,1\n3,4,1\n4,3,1\n5,2,1\n6,5,1\n7,1,1\n8,3,1\n9,4,1\n";
    protected String sourcesPath;
    protected String targetsPath;
    protected String resultPath;

    public LineRankITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.sourcesPath = this.createTempFile("sourceIncidence.txt", SOURCE_INCIDENCE);
        this.targetsPath = this.createTempFile("targetIncidence.txt", TARGET_INCIDENCE);
        this.resultPath = this.getTempFilePath("results");
    }

    protected Plan getTestJob() {
        LineRank lr = new LineRank();
        ScalaPlan plan = lr.getScalaPlan(this.config.getInteger("NumSubtasks", 1), this.sourcesPath, this.targetsPath, 9, this.resultPath);
        return plan;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config1 = new Configuration();
        config1.setInteger("NumSubtasks", 4);
        config1.setInteger("NumIterations", 5);
        return LineRankITCase.toParameterList((Configuration[])new Configuration[]{config1});
    }
}

