/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.BulkIteration;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.recordJobs.kmeans.udfs.PointInFormat;
import eu.stratosphere.test.recordJobs.kmeans.udfs.PointOutFormat;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.Record;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IterationWithUnionITCase
extends RecordAPITestBase {
    private static final String DATAPOINTS = "0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n";
    protected String dataPath;
    protected String resultPath;

    public IterationWithUnionITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.dataPath = this.createTempFile("datapoints.txt", DATAPOINTS);
        this.resultPath = this.getTempDirPath("union_iter_result");
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory("0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n0|50.90|16.20|72.08|\n1|73.65|61.76|62.89|\n2|61.73|49.95|92.74|\n", this.resultPath);
    }

    protected Plan getTestJob() {
        return IterationWithUnionITCase.getPlan(this.config.getInteger("IterationWithUnionITCase#NumSubtasks", 1), this.dataPath, this.resultPath);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config1 = new Configuration();
        config1.setInteger("IterationWithUnionITCase#NumSubtasks", 4);
        return IterationWithUnionITCase.toParameterList((Configuration[])new Configuration[]{config1});
    }

    private static Plan getPlan(int numSubTasks, String input, String output) {
        FileDataSource initialInput = new FileDataSource((FileInputFormat)new PointInFormat(), input, "Input");
        initialInput.setDegreeOfParallelism(1);
        BulkIteration iteration = new BulkIteration("Loop");
        iteration.setInput((Operator)initialInput);
        iteration.setMaximumNumberOfIterations(2);
        MapOperator map2 = MapOperator.builder((MapFunction)new IdentityMapper()).input(new Operator[]{iteration.getPartialSolution(), iteration.getPartialSolution()}).name("map").build();
        iteration.setNextPartialSolution((Operator)map2);
        FileDataSink finalResult = new FileDataSink((FileOutputFormat)new PointOutFormat(), output, (Operator)iteration, "Output");
        Plan plan = new Plan((GenericDataSink)finalResult, "Iteration with union test");
        plan.setDefaultParallelism(numSubTasks);
        return plan;
    }

    static final class DummyReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        DummyReducer() {
        }

        public void reduce(Iterator<Record> it, Collector<Record> out) {
            while (it.hasNext()) {
                out.collect((Object)it.next());
            }
        }
    }

    static final class IdentityMapper
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        IdentityMapper() {
        }

        public void map(Record rec, Collector<Record> out) {
            out.collect((Object)rec);
        }
    }
}

