/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.operators.BulkIteration;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.io.CsvOutputFormat;
import eu.stratosphere.api.java.record.io.TextInputFormat;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.test.util.RecordAPITestBase;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Iterator;
import org.junit.Assert;

public class IterationTerminationWithTerminationTail
extends RecordAPITestBase {
    private static final String INPUT = "1\n2\n3\n4\n5\n";
    private static final String EXPECTED = "22\n";
    protected String dataPath;
    protected String resultPath;

    protected void preSubmit() throws Exception {
        this.dataPath = this.createTempFile("datapoints.txt", INPUT);
        this.resultPath = this.getTempFilePath("result");
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(EXPECTED, this.resultPath);
    }

    protected Plan getTestJob() {
        return IterationTerminationWithTerminationTail.getTestPlanPlan(4, this.dataPath, this.resultPath);
    }

    private static Plan getTestPlanPlan(int numSubTasks, String input, String output) {
        FileDataSource initialInput = new FileDataSource(TextInputFormat.class, input, "input");
        BulkIteration iteration = new BulkIteration("Loop");
        iteration.setInput((Operator)initialInput);
        iteration.setMaximumNumberOfIterations(5);
        Assert.assertTrue((iteration.getMaximumNumberOfIterations() > 1 ? 1 : 0) != 0);
        ReduceOperator sumReduce = ReduceOperator.builder((ReduceFunction)new SumReducer()).input(new Operator[]{iteration.getPartialSolution()}).name("Compute sum (Reduce)").build();
        iteration.setNextPartialSolution((Operator)sumReduce);
        MapOperator terminationMapper = MapOperator.builder((MapFunction)new TerminationMapper()).input(new Operator[]{sumReduce}).name("Compute termination criterion (Map)").build();
        iteration.setTerminationCriterion((Operator)terminationMapper);
        FileDataSink finalResult = new FileDataSink(CsvOutputFormat.class, output, (Operator)iteration, "Output");
        ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)finalResult).recordDelimiter('\n')).fieldDelimiter(' ')).field(StringValue.class, 0);
        Plan plan = new Plan((GenericDataSink)finalResult, "Iteration with AllReducer (keyless Reducer)");
        plan.setDefaultParallelism(numSubTasks);
        Assert.assertTrue((plan.getDefaultParallelism() > 1 ? 1 : 0) != 0);
        return plan;
    }

    public static class TerminationMapper
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> collector) {
            int currentSum = Integer.parseInt(((StringValue)record.getField(0, StringValue.class)).getValue());
            if (currentSum < 22) {
                collector.collect((Object)record);
            }
        }
    }

    public static final class SumReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void reduce(Iterator<Record> it, Collector<Record> out) {
            int sum = 0;
            while (it.hasNext()) {
                sum += Integer.parseInt(((StringValue)it.next().getField(0, StringValue.class)).getValue()) + 1;
            }
            out.collect((Object)new Record((Value)new StringValue((CharSequence)Integer.toString(sum))));
        }
    }
}

