/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.recordJobs.graph.WorksetConnectedComponents;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeltaPageRankITCase
extends RecordAPITestBase {
    protected String verticesPath;
    protected String edgesPath;
    protected String deltasPath;
    protected String resultPath;
    private static final String INITIAL_VERTICES_WITH_RANK = "1 0.025\n2 0.125\n3 0.0833333333333333\n4 0.0833333333333333\n5 0.075\n6 0.075\n7 0.183333333333333\n8 0.15\n9 0.1\n";
    private static final String INITIAL_DELTAS = "1 -0.075\n2 0.025\n3 -0.0166666666666667\n4 -0.0166666666666667\n5 -0.025\n6 -0.025\n7 0.0833333333333333\n8 0.05\n9 0\n";
    private static final String EDGES = "1 2 2\n1 3 2\n2 3 3\n2 4 3\n3 1 4\n3 2 4\n4 2 2\n5 6 2\n6 5 2\n7 8 2\n7 9 2\n8 7 2\n8 9 2\n9 7 2\n9 8 2\n3 5 4\n3 6 4\n4 8 2\n2 7 3\n5 7 2\n6 4 2\n";

    public DeltaPageRankITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.verticesPath = this.createTempFile("vertices.txt", INITIAL_VERTICES_WITH_RANK);
        this.deltasPath = this.createTempFile("deltas.txt", INITIAL_DELTAS);
        this.edgesPath = this.createTempFile("edges.txt", EDGES);
        this.resultPath = this.getTempFilePath("results");
    }

    protected Plan getTestJob() {
        int dop = this.config.getInteger("NumSubtasks", 1);
        int maxIterations = this.config.getInteger("NumIterations", 1);
        String[] params = new String[]{String.valueOf(dop), this.verticesPath, this.edgesPath, this.resultPath, String.valueOf(maxIterations)};
        WorksetConnectedComponents cc = new WorksetConnectedComponents();
        return cc.getPlan(params);
    }

    protected void postSubmit() throws Exception {
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config1 = new Configuration();
        config1.setInteger("NumSubtasks", 4);
        config1.setInteger("NumIterations", 3);
        return DeltaPageRankITCase.toParameterList((Configuration[])new Configuration[]{config1});
    }
}

