/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.iterative;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.test.recordJobs.graph.DanglingPageRank;
import eu.stratosphere.test.util.RecordAPITestBase;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DanglingPageRankITCase
extends RecordAPITestBase {
    protected String pagesPath;
    protected String edgesPath;
    protected String resultPath;

    public DanglingPageRankITCase(Configuration config) {
        super(config);
    }

    protected void preSubmit() throws Exception {
        this.pagesPath = this.createTempFile("pages.txt", "1\n2\n5\n3 1\n4");
        this.edgesPath = this.createTempFile("edges.txt", "2 1\n5 2 4\n4 3 2\n1 4 2 3");
        this.resultPath = this.getTempFilePath("results");
    }

    protected Plan getTestJob() {
        DanglingPageRank pr = new DanglingPageRank();
        Plan plan = pr.getPlan(this.config.getString("PageRankITCase#NoSubtasks", "1"), this.pagesPath, this.edgesPath, this.resultPath, this.config.getString("PageRankITCase#NumIterations", "25"), "5", "1");
        return plan;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() {
        Configuration config1 = new Configuration();
        config1.setInteger("PageRankITCase#NoSubtasks", 4);
        config1.setString("PageRankITCase#NumIterations", "25");
        return DanglingPageRankITCase.toParameterList((Configuration[])new Configuration[]{config1});
    }
}

