/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.failingPrograms;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plantranslate.NepheleJobGraphGenerator;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import eu.stratosphere.test.operators.io.ContractITCaseIOFormats;
import eu.stratosphere.test.util.FailingTestBase;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;

public class TaskFailureITCase
extends FailingTestBase {
    private static final String MAP_IN = "1 1\n2 2\n2 8\n4 4\n4 4\n6 6\n7 7\n8 8\n1 1\n2 2\n2 2\n4 4\n4 4\n6 3\n5 9\n8 8\n1 1\n2 2\n2 2\n3 0\n4 4\n5 9\n7 7\n8 8\n1 1\n9 1\n5 9\n4 4\n4 4\n6 6\n7 7\n8 8\n";
    private static final String MAP_RESULT = "1 11\n2 12\n4 14\n4 14\n1 11\n2 12\n2 12\n4 14\n4 14\n3 16\n1 11\n2 12\n2 12\n0 13\n4 14\n1 11\n4 14\n4 14\n";
    private String inputPath;
    private String resultPath;

    protected void preSubmit() throws Exception {
        this.inputPath = this.createTempFile("input", MAP_IN);
        this.resultPath = this.getTempDirPath("result");
    }

    @Override
    protected JobGraph getFailingJobGraph() throws Exception {
        FileDataSource input = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.inputPath);
        MapOperator testMapper = MapOperator.builder(FailingMapper.class).build();
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setInput((Operator)testMapper);
        testMapper.setInput((Operator)input);
        Plan plan = new Plan((GenericDataSink)output);
        plan.setDefaultParallelism(4);
        PactCompiler pc = new PactCompiler(new DataStatistics());
        OptimizedPlan op = pc.compile(plan);
        NepheleJobGraphGenerator jgg = new NepheleJobGraphGenerator();
        return jgg.compileJobGraph(op);
    }

    protected JobGraph getJobGraph() throws Exception {
        FileDataSource input = new FileDataSource((FileInputFormat)new ContractITCaseIOFormats.ContractITCaseInputFormat(), this.inputPath);
        MapOperator testMapper = MapOperator.builder(TestMapper.class).build();
        FileDataSink output = new FileDataSink((FileOutputFormat)new ContractITCaseIOFormats.ContractITCaseOutputFormat(), this.resultPath);
        output.setInput((Operator)testMapper);
        testMapper.setInput((Operator)input);
        Plan plan = new Plan((GenericDataSink)output);
        plan.setDefaultParallelism(4);
        PactCompiler pc = new PactCompiler(new DataStatistics());
        OptimizedPlan op = pc.compile(plan);
        NepheleJobGraphGenerator jgg = new NepheleJobGraphGenerator();
        return jgg.compileJobGraph(op);
    }

    protected void postSubmit() throws Exception {
        this.compareResultsByLinesInMemory(MAP_RESULT, this.resultPath);
    }

    @Override
    protected int getTimeout() {
        return 30;
    }

    public static class FailingMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> out) throws Exception {
            throw new RuntimeException("This is an expected Test Exception");
        }
    }

    public static class TestMapper
    extends MapFunction {
        private static final long serialVersionUID = 1L;
        private final StringValue string = new StringValue();
        private final IntValue integer = new IntValue();

        public void map(Record record, Collector<Record> out) throws Exception {
            StringValue valueString;
            int value;
            StringValue keyString = (StringValue)record.getField(0, (Value)this.string);
            int key = Integer.parseInt(keyString.toString());
            if (key + (value = Integer.parseInt((valueString = (StringValue)record.getField(1, (Value)this.string)).toString())) < 10) {
                record.setField(0, (Value)valueString);
                this.integer.setValue(key + 10);
                record.setField(1, (Value)this.integer);
                out.collect((Object)record);
            }
        }
    }
}

