/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.exampleJavaPrograms;

import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.example.java.graph.PageRankBasic;
import eu.stratosphere.test.util.JavaProgramTestBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PageRankITCase
extends JavaProgramTestBase {
    private static int NUM_PROGRAMS = 2;
    private int curProgId;
    private String verticesPath;
    private String edgesPath;
    private String resultPath;
    private String expectedResult;

    public PageRankITCase(Configuration config) {
        super(config);
        this.curProgId = this.config.getInteger("ProgramId", -1);
    }

    protected void preSubmit() throws Exception {
        this.resultPath = this.getTempDirPath("result");
        this.verticesPath = this.createTempFile("vertices.txt", "1 0.2\n2 0.2\n5 0.2\n3 0.2\n4 0.2");
        this.edgesPath = this.createTempFile("edges.txt", "2 1\n5 2\n5 4\n4 3\n4 2\n1 4\n1 2\n1 3\n3 5\n");
    }

    protected void testProgram() throws Exception {
        this.expectedResult = this.runProgram(this.curProgId);
    }

    protected void postSubmit() throws Exception {
        this.compareKeyValueParisWithDelta(this.expectedResult, this.resultPath, " ", 0.01);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getConfigurations() throws FileNotFoundException, IOException {
        LinkedList<Configuration> tConfigs = new LinkedList<Configuration>();
        for (int i = 1; i <= NUM_PROGRAMS; ++i) {
            Configuration config = new Configuration();
            config.setInteger("ProgramId", i);
            tConfigs.add(config);
        }
        return PageRankITCase.toParameterList(tConfigs);
    }

    public String runProgram(int progId) throws Exception {
        switch (progId) {
            case 1: {
                PageRankBasic.main((String[])new String[]{this.verticesPath, this.edgesPath, this.resultPath, "5", "3"});
                return "1 0.237\n2 0.248\n3 0.173\n4 0.175\n5 0.165";
            }
            case 2: {
                PageRankBasic.main((String[])new String[]{this.verticesPath, this.edgesPath, this.resultPath, "5", "1000"});
                return "1 0.238\n2 0.244\n3 0.170\n4 0.171\n5 0.174";
            }
        }
        throw new IllegalArgumentException("Invalid program id");
    }
}

