/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.compiler.plandump;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.plandump.PlanJSONDumpGenerator;
import eu.stratosphere.test.recordJobs.graph.DeltaPageRankWithInitialDeltas;
import eu.stratosphere.test.recordJobs.kmeans.KMeansBroadcast;
import eu.stratosphere.test.recordJobs.kmeans.KMeansSingleStep;
import eu.stratosphere.test.recordJobs.relational.TPCHQuery3;
import eu.stratosphere.test.recordJobs.relational.WebLogAnalysis;
import eu.stratosphere.test.recordJobs.wordcount.WordCount;
import eu.stratosphere.util.OperatingSystem;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.junit.Assert;
import org.junit.Test;

public class PreviewPlanDumpTest {
    protected static final String IN_FILE = OperatingSystem.isWindows() ? "file:/c:/test/file" : "file:///test/file";
    protected static final String OUT_FILE = OperatingSystem.isWindows() ? "file:/c:/test/output" : "file:///test/output";
    protected static final String[] NO_ARGS = new String[0];

    @Test
    public void dumpWordCount() {
        this.dump(new WordCount().getPlan("4", IN_FILE, OUT_FILE));
        this.dump(new WordCount().getPlan(NO_ARGS));
    }

    @Test
    public void dumpTPCH3() {
        this.dump(new TPCHQuery3().getPlan("4", IN_FILE, IN_FILE, OUT_FILE));
        this.dump(new TPCHQuery3().getPlan(NO_ARGS));
    }

    @Test
    public void dumpKMeans() {
        this.dump(new KMeansSingleStep().getPlan("4", IN_FILE, IN_FILE, OUT_FILE));
        this.dump(new KMeansSingleStep().getPlan(NO_ARGS));
    }

    @Test
    public void dumpWebLogAnalysis() {
        this.dump(new WebLogAnalysis().getPlan("4", IN_FILE, IN_FILE, IN_FILE, OUT_FILE));
        this.dump(new WebLogAnalysis().getPlan(NO_ARGS));
    }

    @Test
    public void dumpBulkIterationKMeans() {
        this.dump(new KMeansBroadcast().getPlan("4", IN_FILE, OUT_FILE));
        this.dump(new KMeansBroadcast().getPlan(NO_ARGS));
    }

    @Test
    public void dumpDeltaPageRank() {
        this.dump(new DeltaPageRankWithInitialDeltas().getPlan("4", IN_FILE, IN_FILE, IN_FILE, OUT_FILE, "10"));
        this.dump(new DeltaPageRankWithInitialDeltas().getPlan(NO_ARGS));
    }

    private void dump(Plan p) {
        try {
            List sinks = PactCompiler.createPreOptimizedPlan((Plan)p);
            PlanJSONDumpGenerator dumper = new PlanJSONDumpGenerator();
            String json = dumper.getPactPlanAsJSON(sinks);
            JsonParser parser = new JsonFactory().createJsonParser(json);
            while (parser.nextToken() != null) {
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            Assert.fail((String)("JSON Generator produced malformatted output: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An error occurred in the test: " + e.getMessage()));
        }
    }
}

