/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.compiler.plandump;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plandump.PlanJSONDumpGenerator;
import eu.stratosphere.test.compiler.CompilerTestBase;
import eu.stratosphere.test.recordJobs.graph.DeltaPageRankWithInitialDeltas;
import eu.stratosphere.test.recordJobs.kmeans.KMeansBroadcast;
import eu.stratosphere.test.recordJobs.kmeans.KMeansSingleStep;
import eu.stratosphere.test.recordJobs.relational.TPCHQuery3;
import eu.stratosphere.test.recordJobs.relational.WebLogAnalysis;
import eu.stratosphere.test.recordJobs.wordcount.WordCount;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.junit.Assert;
import org.junit.Test;

public class DumpCompiledPlanTest
extends CompilerTestBase {
    @Test
    public void dumpWordCount() {
        this.dump(new WordCount().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpTPCH3() {
        this.dump(new TPCHQuery3().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpKMeans() {
        this.dump(new KMeansSingleStep().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpWebLogAnalysis() {
        this.dump(new WebLogAnalysis().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpBulkIterationKMeans() {
        this.dump(new KMeansBroadcast().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, OUT_FILE));
    }

    @Test
    public void dumpDeltaPageRank() {
        this.dump(new DeltaPageRankWithInitialDeltas().getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, IN_FILE, IN_FILE, OUT_FILE, "10"));
    }

    private void dump(Plan p) {
        try {
            OptimizedPlan op = this.compileNoStats(p);
            PlanJSONDumpGenerator dumper = new PlanJSONDumpGenerator();
            String json = dumper.getOptimizerPlanAsJSON(op);
            JsonParser parser = new JsonFactory().createJsonParser(json);
            while (parser.nextToken() != null) {
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            Assert.fail((String)("JSON Generator produced malformatted output: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An error occurred in the test: " + e.getMessage()));
        }
    }
}

