/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.compiler.examples;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.distributions.DataDistribution;
import eu.stratosphere.api.common.distributions.SimpleDistribution;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.GenericDataSource;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.api.common.operators.Ordering;
import eu.stratosphere.api.common.operators.util.FieldList;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.io.CsvOutputFormat;
import eu.stratosphere.api.java.record.io.TextInputFormat;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.compiler.plan.Channel;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.compiler.plan.SinkPlanNode;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.util.LocalStrategy;
import eu.stratosphere.test.compiler.CompilerTestBase;
import eu.stratosphere.test.recordJobs.wordcount.WordCount;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Key;
import eu.stratosphere.types.StringValue;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class WordCountCompilerTest
extends CompilerTestBase {
    @Test
    public void testWordCount() {
        this.checkWordCount(true);
        this.checkWordCount(false);
    }

    private void checkWordCount(boolean estimates) {
        try {
            OptimizedPlan plan;
            WordCount wc = new WordCount();
            Plan p = wc.getPlan(DEFAULT_PARALLELISM_STRING, IN_FILE, OUT_FILE);
            if (estimates) {
                FileDataSource source = (FileDataSource)WordCountCompilerTest.getContractResolver(p).getNode("Input Lines");
                this.setSourceStatistics((GenericDataSource<?>)source, 0x10000000000L, 24.0f);
                plan = this.compileWithStats(p);
            } else {
                plan = this.compileNoStats(p);
            }
            CompilerTestBase.OptimizerPlanNodeResolver resolver = WordCountCompilerTest.getOptimizerPlanNodeResolver(plan);
            SinkPlanNode sink = (SinkPlanNode)resolver.getNode("Word Counts");
            SingleInputPlanNode reducer = (SingleInputPlanNode)resolver.getNode("Count Words");
            SingleInputPlanNode mapper = (SingleInputPlanNode)resolver.getNode("Tokenize Lines");
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)mapper.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_HASH, (Object)reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Channel c = reducer.getInput();
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)c.getLocalStrategy());
            FieldList l = new FieldList(0);
            Assert.assertEquals((Object)l, (Object)c.getShipStrategyKeys());
            Assert.assertEquals((Object)l, (Object)c.getLocalStrategyKeys());
            Assert.assertTrue((boolean)Arrays.equals(c.getLocalStrategySortOrder(), reducer.getSortOrders()));
            SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getPredecessor();
            Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_COMBINE, (Object)combiner.getDriverStrategy());
            Assert.assertEquals((Object)l, (Object)combiner.getKeys());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWordCountWithSortedSink() {
        this.checkWordCountWithSortedSink(true);
        this.checkWordCountWithSortedSink(false);
    }

    private void checkWordCountWithSortedSink(boolean estimates) {
        try {
            OptimizedPlan plan;
            FileDataSource sourceNode = new FileDataSource((FileInputFormat)new TextInputFormat(), IN_FILE, "Input Lines");
            MapOperator mapNode = MapOperator.builder((MapFunction)new WordCount.TokenizeLine()).input(new Operator[]{sourceNode}).name("Tokenize Lines").build();
            ReduceOperator reduceNode = ReduceOperator.builder((ReduceFunction)new WordCount.CountWords(), StringValue.class, (int)0).input(new Operator[]{mapNode}).name("Count Words").build();
            FileDataSink out = new FileDataSink((FileOutputFormat)new CsvOutputFormat(), OUT_FILE, (Operator)reduceNode, "Word Counts");
            ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)out).recordDelimiter('\n')).fieldDelimiter(' ')).lenient(true)).field(StringValue.class, 0)).field(IntValue.class, 1);
            Ordering ordering = new Ordering(0, StringValue.class, Order.DESCENDING);
            out.setGlobalOrder(ordering, (DataDistribution)new SimpleDistribution((Key[])new StringValue[]{new StringValue((CharSequence)"N")}));
            Plan p = new Plan((GenericDataSink)out, "WordCount Example");
            p.setDefaultParallelism(8);
            if (estimates) {
                this.setSourceStatistics((GenericDataSource<?>)sourceNode, 0x10000000000L, 24.0f);
                plan = this.compileWithStats(p);
            } else {
                plan = this.compileNoStats(p);
            }
            CompilerTestBase.OptimizerPlanNodeResolver resolver = WordCountCompilerTest.getOptimizerPlanNodeResolver(plan);
            SinkPlanNode sink = (SinkPlanNode)resolver.getNode("Word Counts");
            SingleInputPlanNode reducer = (SingleInputPlanNode)resolver.getNode("Count Words");
            SingleInputPlanNode mapper = (SingleInputPlanNode)resolver.getNode("Tokenize Lines");
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)mapper.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_RANGE, (Object)reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)sink.getInput().getShipStrategy());
            Channel c = reducer.getInput();
            Assert.assertEquals((Object)LocalStrategy.COMBININGSORT, (Object)c.getLocalStrategy());
            FieldList l = new FieldList(0);
            Assert.assertEquals((Object)l, (Object)c.getShipStrategyKeys());
            Assert.assertEquals((Object)l, (Object)c.getLocalStrategyKeys());
            Assert.assertFalse((boolean)c.getShipStrategySortOrder()[0]);
            Assert.assertFalse((boolean)c.getLocalStrategySortOrder()[0]);
            SingleInputPlanNode combiner = (SingleInputPlanNode)reducer.getPredecessor();
            Assert.assertEquals((Object)DriverStrategy.SORTED_GROUP_COMBINE, (Object)combiner.getDriverStrategy());
            Assert.assertEquals((Object)l, (Object)combiner.getKeys());
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)combiner.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

