/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.compiler;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.functions.Function;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.statistics.BaseStatistics;
import eu.stratosphere.api.common.operators.BulkIteration;
import eu.stratosphere.api.common.operators.DeltaIteration;
import eu.stratosphere.api.common.operators.GenericDataSource;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.costs.CostEstimator;
import eu.stratosphere.compiler.costs.DefaultCostEstimator;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plan.PlanNode;
import eu.stratosphere.compiler.plan.SingleInputPlanNode;
import eu.stratosphere.nephele.instance.HardwareDescription;
import eu.stratosphere.nephele.instance.HardwareDescriptionFactory;
import eu.stratosphere.nephele.instance.InstanceType;
import eu.stratosphere.nephele.instance.InstanceTypeDescription;
import eu.stratosphere.nephele.instance.InstanceTypeDescriptionFactory;
import eu.stratosphere.nephele.instance.InstanceTypeFactory;
import eu.stratosphere.util.OperatingSystem;
import eu.stratosphere.util.Visitor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Before;

public abstract class CompilerTestBase {
    protected static final String IN_FILE = OperatingSystem.isWindows() ? "file:/c:/" : "file:///dev/random";
    protected static final String OUT_FILE = OperatingSystem.isWindows() ? "file:/c:/" : "file:///dev/null";
    protected static final int DEFAULT_PARALLELISM = 8;
    protected static final String DEFAULT_PARALLELISM_STRING = String.valueOf(8);
    private static final String CACHE_KEY = "cachekey";
    protected DataStatistics dataStats;
    protected PactCompiler withStatsCompiler;
    protected PactCompiler noStatsCompiler;
    protected InstanceTypeDescription instanceType;
    private int statCounter;

    @Before
    public void setup() {
        InetSocketAddress dummyAddr = new InetSocketAddress("localhost", 12345);
        this.dataStats = new DataStatistics();
        this.withStatsCompiler = new PactCompiler(this.dataStats, (CostEstimator)new DefaultCostEstimator(), dummyAddr);
        this.withStatsCompiler.setDefaultDegreeOfParallelism(8);
        this.noStatsCompiler = new PactCompiler(null, (CostEstimator)new DefaultCostEstimator(), dummyAddr);
        this.noStatsCompiler.setDefaultDegreeOfParallelism(8);
        InstanceType iType = InstanceTypeFactory.construct((String)"standard", (int)6, (int)2, (int)4096, (int)100, (int)0);
        HardwareDescription hDesc = HardwareDescriptionFactory.construct((int)2, (long)0L, (long)0x7D000000L);
        this.instanceType = InstanceTypeDescriptionFactory.construct((InstanceType)iType, (HardwareDescription)hDesc, (int)16);
    }

    public OptimizedPlan compileWithStats(Plan p) {
        return this.withStatsCompiler.compile(p, this.instanceType);
    }

    public OptimizedPlan compileNoStats(Plan p) {
        return this.noStatsCompiler.compile(p, this.instanceType);
    }

    public void setSourceStatistics(GenericDataSource<?> source, long size, float recordWidth) {
        this.setSourceStatistics(source, new FileInputFormat.FileBaseStatistics(Long.MAX_VALUE, size, recordWidth));
    }

    public void setSourceStatistics(GenericDataSource<?> source, FileInputFormat.FileBaseStatistics stats) {
        String key = CACHE_KEY + this.statCounter++;
        this.dataStats.cacheBaseStatistics((BaseStatistics)stats, key);
        source.setStatisticsKey(key);
    }

    public static ContractResolver getContractResolver(Plan plan) {
        return new ContractResolver(plan);
    }

    public static OptimizerPlanNodeResolver getOptimizerPlanNodeResolver(OptimizedPlan plan) {
        return new OptimizerPlanNodeResolver(plan);
    }

    public static final class ContractResolver
    implements Visitor<Operator> {
        private final Map<String, List<Operator>> map = new HashMap<String, List<Operator>>();
        private Set<Operator> seen = new HashSet<Operator>();

        ContractResolver(Plan p) {
            p.accept((Visitor)this);
            this.seen = null;
        }

        public <T extends Operator> T getNode(String name) {
            List<Operator> nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No nodes found with the given name.");
            }
            if (nodes.size() != 1) {
                throw new RuntimeException("Multiple nodes found with the given name.");
            }
            return (T)nodes.get(0);
        }

        public <T extends Operator> T getNode(String name, Class<? extends Function> stubClass) {
            List<Operator> nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No node found with the given name and stub class.");
            }
            Operator found = null;
            for (Operator node : nodes) {
                if (node.getClass() != stubClass) continue;
                if (found == null) {
                    found = node;
                    continue;
                }
                throw new RuntimeException("Multiple nodes found with the given name and stub class.");
            }
            if (found == null) {
                throw new RuntimeException("No node found with the given name and stub class.");
            }
            return (T)found;
        }

        public List<Operator> getNodes(String name) {
            List<Operator> nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No node found with the given name.");
            }
            return new ArrayList<Operator>(nodes);
        }

        public boolean preVisit(Operator visitable) {
            if (this.seen.add(visitable)) {
                String name = visitable.getName();
                List<Operator> list = this.map.get(name);
                if (list == null) {
                    list = new ArrayList<Operator>(2);
                    this.map.put(name, list);
                }
                list.add(visitable);
                if (visitable instanceof BulkIteration) {
                    ((BulkIteration)visitable).getNextPartialSolution().accept((Visitor)this);
                } else if (visitable instanceof DeltaIteration) {
                    ((DeltaIteration)visitable).getSolutionSetDelta().accept((Visitor)this);
                    ((DeltaIteration)visitable).getNextWorkset().accept((Visitor)this);
                }
                return true;
            }
            return false;
        }

        public void postVisit(Operator visitable) {
        }
    }

    public static final class OptimizerPlanNodeResolver {
        private final Map<String, ArrayList<PlanNode>> map;

        OptimizerPlanNodeResolver(OptimizedPlan p) {
            HashMap<String, ArrayList<PlanNode>> map = new HashMap<String, ArrayList<PlanNode>>();
            for (PlanNode n : p.getAllNodes()) {
                Operator c = n.getOriginalOptimizerNode().getPactContract();
                String name = c.getName();
                ArrayList<Object> list = map.get(name);
                if (list == null) {
                    list = new ArrayList(2);
                    map.put(name, list);
                }
                boolean shouldAdd = true;
                Iterator<PlanNode> iter = list.iterator();
                while (iter.hasNext()) {
                    PlanNode in = iter.next();
                    if (in.getOriginalOptimizerNode().getPactContract() != c) continue;
                    if (in instanceof SingleInputPlanNode && n instanceof SingleInputPlanNode) {
                        SingleInputPlanNode thisNode = (SingleInputPlanNode)n;
                        SingleInputPlanNode otherNode = (SingleInputPlanNode)in;
                        if (thisNode.getPredecessor() == otherNode) {
                            iter.remove();
                            continue;
                        }
                        if (otherNode.getPredecessor() != thisNode) continue;
                        shouldAdd = false;
                        continue;
                    }
                    throw new RuntimeException("Unrecodnized case in test.");
                }
                if (!shouldAdd) continue;
                list.add(n);
            }
            this.map = map;
        }

        public <T extends PlanNode> T getNode(String name) {
            List nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No node found with the given name.");
            }
            if (nodes.size() != 1) {
                throw new RuntimeException("Multiple nodes found with the given name.");
            }
            return (T)((PlanNode)nodes.get(0));
        }

        public <T extends PlanNode> T getNode(String name, Class<? extends Function> stubClass) {
            List nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No node found with the given name and stub class.");
            }
            PlanNode found = null;
            for (PlanNode node : nodes) {
                if (node.getClass() != stubClass) continue;
                if (found == null) {
                    found = node;
                    continue;
                }
                throw new RuntimeException("Multiple nodes found with the given name and stub class.");
            }
            if (found == null) {
                throw new RuntimeException("No node found with the given name and stub class.");
            }
            return (T)found;
        }

        public List<PlanNode> getNodes(String name) {
            List nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No node found with the given name.");
            }
            return new ArrayList<PlanNode>(nodes);
        }
    }
}

