/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.test.util;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import eu.stratosphere.api.common.Plan;
import eu.stratosphere.client.minicluster.NepheleMiniCluster;
import eu.stratosphere.compiler.DataStatistics;
import eu.stratosphere.compiler.PactCompiler;
import eu.stratosphere.compiler.plan.OptimizedPlan;
import eu.stratosphere.compiler.plandump.PlanJSONDumpGenerator;
import eu.stratosphere.compiler.plantranslate.NepheleJobGraphGenerator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.nephele.client.JobClient;
import eu.stratosphere.nephele.client.JobExecutionResult;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import eu.stratosphere.util.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TestBase2 {
    private static final int MINIMUM_HEAP_SIZE_MB = 192;
    protected final Configuration config;
    private final List<File> tempFiles;
    private NepheleMiniCluster executer;
    protected boolean printPlan = false;
    private JobExecutionResult jobExecutionResult;

    public TestBase2(Configuration config) {
        this.verifyJvmOptions();
        this.config = config;
        this.tempFiles = new ArrayList<File>();
        LogUtils.initializeDefaultConsoleLogger((Level)Level.WARN);
    }

    private void verifyJvmOptions() {
        long heap = Runtime.getRuntime().maxMemory() >> 20;
        Assert.assertTrue((String)("Insufficient java heap space " + heap + "mb - set JVM option: -Xmx" + 192 + "m"), (heap > 142L ? 1 : 0) != 0);
    }

    @Before
    public void startCluster() throws Exception {
        this.executer = new NepheleMiniCluster();
        this.executer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void stopCluster() throws Exception {
        try {
            if (this.executer != null) {
                this.executer.stop();
                this.executer = null;
                FileSystem.closeAll();
                System.gc();
            }
        }
        finally {
            this.deleteAllTempFiles();
        }
    }

    @Test
    public void testJob() throws Exception {
        try {
            this.preSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
        }
        JobGraph jobGraph = null;
        try {
            jobGraph = this.getJobGraph();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)"Failed to obtain JobGraph!");
        }
        Assert.assertNotNull((String)"Obtained null JobGraph", (Object)jobGraph);
        try {
            JobClient client = this.executer.getJobClient(jobGraph);
            client.setConsoleStreamForReporting(TestBase2.getNullPrintStream());
            this.jobExecutionResult = client.submitJobAndWait();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)"Job execution failed!");
        }
        try {
            this.postSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
        }
    }

    public String getTempDirPath(String dirName) throws IOException {
        File f = this.createAndRegisterTempFile(dirName);
        return f.toURI().toString();
    }

    public String getTempFilePath(String fileName) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        return f.toURI().toString();
    }

    public String createTempFile(String fileName, String contents) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        Files.write((CharSequence)contents, (File)f, (Charset)Charsets.UTF_8);
        return f.toURI().toString();
    }

    private File createAndRegisterTempFile(String fileName) throws IOException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(baseDir, fileName);
        if (f.exists()) {
            TestBase2.deleteRecursively(f);
        }
        File parentToDelete = f;
        while (true) {
            File parent;
            if ((parent = parentToDelete.getParentFile()) == null) {
                throw new IOException("Missed temp dir while traversing parents of a temp file.");
            }
            if (parent.equals(baseDir)) break;
            parentToDelete = parent;
        }
        Files.createParentDirs((File)f);
        this.tempFiles.add(parentToDelete);
        return f;
    }

    public BufferedReader[] getResultReader(String resultPath) throws IOException {
        File[] files = this.getAllInvolvedFiles(resultPath);
        BufferedReader[] readers = new BufferedReader[files.length];
        for (int i = 0; i < files.length; ++i) {
            readers[i] = new BufferedReader(new FileReader(files[i]));
        }
        return readers;
    }

    public BufferedInputStream[] getResultInputStream(String resultPath) throws IOException {
        File[] files = this.getAllInvolvedFiles(resultPath);
        BufferedInputStream[] inStreams = new BufferedInputStream[files.length];
        for (int i = 0; i < files.length; ++i) {
            inStreams[i] = new BufferedInputStream(new FileInputStream(files[i]));
        }
        return inStreams;
    }

    public void readAllResultLines(List<String> target, String resultPath) throws IOException {
        for (BufferedReader reader : this.getResultReader(resultPath)) {
            String s = null;
            while ((s = reader.readLine()) != null) {
                target.add(s);
            }
        }
    }

    public void compareResultsByLinesInMemory(String expectedResultStr, String resultPath) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        this.readAllResultLines(list, resultPath);
        Object[] result = list.toArray(new String[list.size()]);
        Arrays.sort(result);
        Object[] expected = expectedResultStr.split("\n");
        Arrays.sort(expected);
        Assert.assertEquals((String)"Different number of lines in expected and obtained result.", (long)expected.length, (long)result.length);
        Assert.assertArrayEquals((Object[])expected, (Object[])result);
    }

    private File[] getAllInvolvedFiles(String resultPath) {
        File result = this.asFile(resultPath);
        if (!result.exists()) {
            Assert.fail((String)"Result file was not written");
        }
        if (result.isDirectory()) {
            return result.listFiles();
        }
        return new File[]{result};
    }

    public File asFile(String path) {
        try {
            URI uri = new URI(path);
            if (uri.getScheme().equals("file")) {
                return new File(uri.getPath());
            }
            throw new IllegalArgumentException("This path does not denote a local file.");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("This path does not describe a valid local file URI.");
        }
    }

    private void deleteAllTempFiles() throws IOException {
        for (File f : this.tempFiles) {
            if (!f.exists()) continue;
            TestBase2.deleteRecursively(f);
        }
    }

    protected JobGraph getJobGraph() throws Exception {
        Plan p = this.getTestJob();
        if (p == null) {
            Assert.fail((String)"Error: Cannot obtain Pact plan. Did the thest forget to override either 'getPactPlan()' or 'getJobGraph()' ?");
        }
        PactCompiler pc = new PactCompiler(new DataStatistics());
        OptimizedPlan op = pc.compile(p);
        if (this.printPlan) {
            System.out.println(new PlanJSONDumpGenerator().getOptimizerPlanAsJSON(op));
        }
        NepheleJobGraphGenerator jgg = new NepheleJobGraphGenerator();
        return jgg.compileJobGraph(op);
    }

    protected Plan getTestJob() {
        return null;
    }

    protected void preSubmit() throws Exception {
    }

    protected void postSubmit() throws Exception {
    }

    public JobExecutionResult getJobExecutionResult() {
        return this.jobExecutionResult;
    }

    protected static Collection<Object[]> toParameterList(Configuration ... testConfigs) {
        ArrayList<Object[]> configs = new ArrayList<Object[]>();
        for (Configuration testConfig : testConfigs) {
            Object[] c = new Object[]{testConfig};
            configs.add(c);
        }
        return configs;
    }

    private static void deleteRecursively(File f) throws IOException {
        if (f.isDirectory()) {
            FileUtils.deleteDirectory((File)f);
        } else {
            f.delete();
        }
    }

    public static PrintStream getNullPrintStream() {
        return new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
    }
}

