/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.relational;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.aggregation.Aggregations;
import eu.stratosphere.api.java.functions.FilterFunction;
import eu.stratosphere.api.java.operators.AggregateOperator;
import eu.stratosphere.api.java.operators.JoinOperator;
import eu.stratosphere.api.java.operators.ProjectOperator;
import eu.stratosphere.api.java.tuple.Tuple2;
import eu.stratosphere.api.java.tuple.Tuple5;

public class RelationalQuery {
    private static String STATUS_FILTER = "F";
    private static int YEAR_FILTER = 1993;
    private static String OPRIO_FILTER = "5";
    private static String ordersPath;
    private static String lineitemPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        if (!RelationalQuery.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple5<Integer, String, String, String, Integer>> orders = RelationalQuery.getOrdersDataSet(env);
        DataSet<Tuple2<Integer, Double>> lineitems = RelationalQuery.getLineitemDataSet(env);
        ProjectOperator ordersFilteredByYear = orders.filter((FilterFunction)new FilterFunction<Tuple5<Integer, String, String, String, Integer>>(){

            public boolean filter(Tuple5<Integer, String, String, String, Integer> t) {
                if (!((String)t.f1).equals(STATUS_FILTER)) {
                    return false;
                }
                if (Integer.parseInt(((String)t.f2).substring(0, 4)) <= YEAR_FILTER) {
                    return false;
                }
                return ((String)t.f3).startsWith(OPRIO_FILTER);
            }
        }).project(new int[]{0, 4}).types(Integer.class, Integer.class);
        JoinOperator.ProjectJoin lineitemsOfOrders = ordersFilteredByYear.joinWithHuge(lineitems).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{0, 1}).projectSecond(new int[]{1}).types(Integer.class, Integer.class, Double.class);
        AggregateOperator priceSums = lineitemsOfOrders.groupBy(new int[]{0, 1}).aggregate(Aggregations.SUM, 2);
        priceSums.writeAsCsv(outputPath);
        env.execute("Relational Query Example");
    }

    private static boolean parseParameters(String[] programArguments) {
        if (programArguments.length > 0) {
            if (programArguments.length != 3) {
                System.err.println("Usage: RelationalQuery <orders-csv path> <lineitem-csv path> <result path>");
                return false;
            }
        } else {
            System.err.println("This program expects data from the TPC-H benchmark as input data.\n  Due to legal restrictions, we can not ship generated data.\n  You can find the TPC-H data generator at http://www.tpc.org/tpch/.\n  Usage: RelationalQuery <orders-csv path> <lineitem-csv path> <result path>");
            return false;
        }
        ordersPath = programArguments[0];
        lineitemPath = programArguments[1];
        outputPath = programArguments[2];
        return true;
    }

    private static DataSet<Tuple5<Integer, String, String, String, Integer>> getOrdersDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(ordersPath).fieldDelimiter('|').includeFields("101011010").types(Integer.class, String.class, String.class, String.class, Integer.class);
    }

    private static DataSet<Tuple2<Integer, Double>> getLineitemDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(lineitemPath).fieldDelimiter('|').includeFields("1000010000000000").types(Integer.class, Double.class);
    }
}

