/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.clustering.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Random;

public class KMeansDataGenerator {
    private static final String CENTERS_FILE = "centers";
    private static final String POINTS_FILE = "points";
    private static final long DEFAULT_SEED = 4650285087650871364L;
    private static final double DEFAULT_VALUE_RANGE = 100.0;
    private static final double RELATIVE_STDDEV = 0.08;
    private static final int DIMENSIONALITY = 2;
    private static final DecimalFormat FORMAT;
    private static final char DELIMITER = ' ';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        int i;
        if (args.length < 2) {
            System.out.println("KMeansDataGenerator <numberOfDataPoints> <numberOfClusterCenters> [<relative stddev>] [<centroid range>] [<seed>]");
            System.exit(1);
        }
        int numDataPoints = Integer.parseInt(args[0]);
        int k = Integer.parseInt(args[1]);
        double stddev = args.length > 2 ? Double.parseDouble(args[2]) : 0.08;
        double range = args.length > 3 ? Double.parseDouble(args[4]) : 100.0;
        long firstSeed = args.length > 4 ? Long.parseLong(args[4]) : 4650285087650871364L;
        double absoluteStdDev = stddev * range;
        Random random = new Random(firstSeed);
        String tmpDir = System.getProperty("java.io.tmpdir");
        double[][] means = KMeansDataGenerator.uniformRandomCenters(random, k, 2, range);
        BufferedWriter pointsOut = null;
        try {
            pointsOut = new BufferedWriter(new FileWriter(new File(tmpDir + "/" + POINTS_FILE)));
            StringBuilder buffer = new StringBuilder();
            double[] point = new double[2];
            int nextCentroid = 0;
            for (i = 1; i <= numDataPoints; ++i) {
                double[] centroid = means[nextCentroid];
                for (int d = 0; d < 2; ++d) {
                    point[d] = random.nextGaussian() * absoluteStdDev + centroid[d];
                }
                KMeansDataGenerator.writePoint(point, buffer, pointsOut);
                nextCentroid = (nextCentroid + 1) % k;
            }
        }
        finally {
            if (pointsOut != null) {
                pointsOut.close();
            }
        }
        BufferedWriter centersOut = null;
        try {
            centersOut = new BufferedWriter(new FileWriter(new File(tmpDir + "/" + CENTERS_FILE)));
            StringBuilder buffer = new StringBuilder();
            double[][] centers = KMeansDataGenerator.uniformRandomCenters(random, k, 2, range);
            for (i = 0; i < k; ++i) {
                KMeansDataGenerator.writeCenter(i + 1, centers[i], buffer, centersOut);
            }
        }
        finally {
            if (centersOut != null) {
                centersOut.close();
            }
        }
        System.out.println("Wrote " + numDataPoints + " data points to " + tmpDir + "/" + POINTS_FILE);
        System.out.println("Wrote " + k + " cluster centers to " + tmpDir + "/" + CENTERS_FILE);
    }

    private static final double[][] uniformRandomCenters(Random rnd, int num, int dimensionality, double range) {
        double halfRange = range / 2.0;
        double[][] points = new double[num][dimensionality];
        for (int i = 0; i < num; ++i) {
            for (int dim = 0; dim < dimensionality; ++dim) {
                points[i][dim] = rnd.nextDouble() * range - halfRange;
            }
        }
        return points;
    }

    private static void writePoint(double[] coordinates, StringBuilder buffer, BufferedWriter out) throws IOException {
        buffer.setLength(0);
        for (int j = 0; j < coordinates.length; ++j) {
            buffer.append(FORMAT.format(coordinates[j]));
            if (j >= coordinates.length - 1) continue;
            buffer.append(' ');
        }
        out.write(buffer.toString());
        out.newLine();
    }

    private static void writeCenter(long id, double[] coordinates, StringBuilder buffer, BufferedWriter out) throws IOException {
        buffer.setLength(0);
        buffer.append(id);
        buffer.append(' ');
        for (int j = 0; j < coordinates.length; ++j) {
            buffer.append(FORMAT.format(coordinates[j]));
            if (j >= coordinates.length - 1) continue;
            buffer.append(' ');
        }
        out.write(buffer.toString());
        out.newLine();
    }

    static {
        Locale.setDefault(Locale.US);
        FORMAT = new DecimalFormat("#0.00");
    }
}

