/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.wordcount;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.aggregation.Aggregations;
import eu.stratosphere.api.java.functions.FlatMapFunction;
import eu.stratosphere.api.java.operators.AggregateOperator;
import eu.stratosphere.api.java.tuple.Tuple2;
import eu.stratosphere.example.java.wordcount.util.WordCountData;
import eu.stratosphere.util.Collector;

public class WordCount {
    private static boolean fileOutput = false;
    private static String textPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        WordCount.parseParameters(args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> text = WordCount.getTextDataSet(env);
        AggregateOperator counts = text.flatMap((FlatMapFunction)new Tokenizer()).groupBy(new int[]{0}).aggregate(Aggregations.SUM, 1);
        if (fileOutput) {
            counts.writeAsCsv(outputPath, "\n", " ");
        } else {
            counts.print();
        }
        env.execute("WordCount Example");
    }

    private static void parseParameters(String[] args) {
        if (args.length > 0) {
            fileOutput = true;
            if (args.length == 2) {
                textPath = args[0];
                outputPath = args[1];
            } else {
                System.err.println("Usage: WordCount <text path> <result path>");
                System.exit(1);
            }
        } else {
            System.out.println("Executing WordCount example with built-in default data.");
            System.out.println("  Provide parameters to read input data from a file.");
            System.out.println("  Usage: WordCount <text path> <result path>");
        }
    }

    private static DataSet<String> getTextDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readTextFile(textPath);
        }
        return WordCountData.getDefaultTextLineDataSet(env);
    }

    public static final class Tokenizer
    extends FlatMapFunction<String, Tuple2<String, Integer>> {
        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) {
            String[] tokens;
            for (String token : tokens = value.toLowerCase().split("\\W+")) {
                if (token.length() <= 0) continue;
                out.collect((Object)new Tuple2((Object)token, (Object)1));
            }
        }
    }
}

