/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.graph;

import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.functions.GroupReduceFunction;
import eu.stratosphere.api.java.functions.JoinFunction;
import eu.stratosphere.api.java.functions.MapFunction;
import eu.stratosphere.api.java.operators.JoinOperator;
import eu.stratosphere.api.java.operators.MapOperator;
import eu.stratosphere.api.java.tuple.Tuple2;
import eu.stratosphere.example.java.graph.util.EnumTrianglesData;
import eu.stratosphere.example.java.graph.util.EnumTrianglesDataTypes;
import eu.stratosphere.util.Collector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EnumTrianglesBasic {
    static boolean fileOutput = false;
    static String edgePath = null;
    static String outputPath = null;

    public static void main(String[] args) throws Exception {
        EnumTrianglesBasic.parseParameters(args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<EnumTrianglesDataTypes.Edge> edges = EnumTrianglesBasic.getEdgeDataSet(env);
        MapOperator edgesById = edges.map((MapFunction)new EdgeByIdProjector());
        JoinOperator.EquiJoin triangles = edgesById.groupBy(new int[]{0}).sortGroup(1, Order.ASCENDING).reduceGroup((GroupReduceFunction)new TriadBuilder()).join((DataSet)edgesById).where(new int[]{1, 2}).equalTo(new int[]{0, 1}).with((JoinFunction)new TriadFilter());
        if (fileOutput) {
            triangles.writeAsCsv(outputPath, "\n", ",");
        } else {
            triangles.print();
        }
        env.execute("Basic Triangle Enumeration Example");
    }

    private static void parseParameters(String[] args) {
        if (args.length > 0) {
            fileOutput = true;
            if (args.length == 2) {
                edgePath = args[0];
                outputPath = args[1];
            } else {
                System.err.println("Usage: EnumTriangleBasic <edge path> <result path>");
                System.exit(1);
            }
        } else {
            System.out.println("Executing Enum Triangles Basic example with built-in default data.");
            System.out.println("  Provide parameters to read input data from files.");
            System.out.println("  See the documentation for the correct format of input files.");
            System.out.println("  Usage: EnumTriangleBasic <edge path> <result path>");
        }
    }

    private static DataSet<EnumTrianglesDataTypes.Edge> getEdgeDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgePath).fieldDelimiter(' ').includeFields(new boolean[]{true, true}).types(Integer.class, Integer.class).map((MapFunction)new TupleEdgeConverter());
        }
        return EnumTrianglesData.getDefaultEdgeDataSet(env);
    }

    private static class TriadFilter
    extends JoinFunction<EnumTrianglesDataTypes.Triad, EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Triad> {
        private TriadFilter() {
        }

        public EnumTrianglesDataTypes.Triad join(EnumTrianglesDataTypes.Triad triad, EnumTrianglesDataTypes.Edge edge) throws Exception {
            return triad;
        }
    }

    private static class TriadBuilder
    extends GroupReduceFunction<EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Triad> {
        private final List<Integer> vertices = new ArrayList<Integer>();
        private final EnumTrianglesDataTypes.Triad outTriad = new EnumTrianglesDataTypes.Triad();

        private TriadBuilder() {
        }

        public void reduce(Iterator<EnumTrianglesDataTypes.Edge> edges, Collector<EnumTrianglesDataTypes.Triad> out) throws Exception {
            this.vertices.clear();
            EnumTrianglesDataTypes.Edge firstEdge = edges.next();
            this.outTriad.setFirstVertex(firstEdge.getFirstVertex());
            this.vertices.add(firstEdge.getSecondVertex());
            while (edges.hasNext()) {
                Integer higherVertexId = edges.next().getSecondVertex();
                for (Integer lowerVertexId : this.vertices) {
                    this.outTriad.setSecondVertex(lowerVertexId);
                    this.outTriad.setThirdVertex(higherVertexId);
                    out.collect((Object)this.outTriad);
                }
                this.vertices.add(higherVertexId);
            }
        }
    }

    private static class EdgeByIdProjector
    extends MapFunction<EnumTrianglesDataTypes.Edge, EnumTrianglesDataTypes.Edge> {
        private EdgeByIdProjector() {
        }

        public EnumTrianglesDataTypes.Edge map(EnumTrianglesDataTypes.Edge inEdge) throws Exception {
            if (inEdge.getFirstVertex() > inEdge.getSecondVertex()) {
                inEdge.flipVertices();
            }
            return inEdge;
        }
    }

    public static class TupleEdgeConverter
    extends MapFunction<Tuple2<Integer, Integer>, EnumTrianglesDataTypes.Edge> {
        private final EnumTrianglesDataTypes.Edge outEdge = new EnumTrianglesDataTypes.Edge();

        public EnumTrianglesDataTypes.Edge map(Tuple2<Integer, Integer> t) throws Exception {
            this.outEdge.copyVerticesFromTuple2(t);
            return this.outEdge;
        }
    }
}

