/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.relational;

import eu.stratosphere.api.java.DataSet;
import eu.stratosphere.api.java.ExecutionEnvironment;
import eu.stratosphere.api.java.aggregation.Aggregations;
import eu.stratosphere.api.java.functions.FilterFunction;
import eu.stratosphere.api.java.functions.JoinFunction;
import eu.stratosphere.api.java.operators.FilterOperator;
import eu.stratosphere.api.java.operators.JoinOperator;
import eu.stratosphere.api.java.tuple.Tuple2;
import eu.stratosphere.api.java.tuple.Tuple3;
import eu.stratosphere.api.java.tuple.Tuple4;
import eu.stratosphere.api.java.tuple.Tuple5;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TPCHQuery3 {
    private static String lineitemPath;
    private static String customerPath;
    private static String ordersPath;
    private static String outputPath;

    public static void main(String[] args) throws Exception {
        TPCHQuery3.parseParameters(args);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        FilterOperator li = TPCHQuery3.getLineitemDataSet(env);
        FilterOperator or = TPCHQuery3.getOrdersDataSet(env);
        FilterOperator cust = TPCHQuery3.getCustomerDataSet(env);
        cust = cust.filter((FilterFunction)new FilterFunction<Customer>(){

            public boolean filter(Customer value) {
                return value.getMktsegment().equals("AUTOMOBILE");
            }
        });
        or = or.filter((FilterFunction)new FilterFunction<Order>(){
            private DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            private Date date;
            {
                Calendar cal = Calendar.getInstance();
                cal.set(1995, 3, 12);
                this.date = cal.getTime();
            }

            public boolean filter(Order value) throws ParseException {
                Date orderDate = this.format.parse(value.getOrderdate());
                return orderDate.before(this.date);
            }
        });
        li = li.filter((FilterFunction)new FilterFunction<Lineitem>(){
            private DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            private Date date;
            {
                Calendar cal = Calendar.getInstance();
                cal.set(1995, 3, 12);
                this.date = cal.getTime();
            }

            public boolean filter(Lineitem value) throws ParseException {
                Date shipDate = this.format.parse(value.getShipdate());
                return shipDate.after(this.date);
            }
        });
        JoinOperator.EquiJoin customerWithOrders = cust.join((DataSet)or).where(new int[]{0}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunction<Customer, Order, ShippingPriorityItem>(){

            public ShippingPriorityItem join(Customer first, Order second) {
                return new ShippingPriorityItem(0, 0.0, second.getOrderdate(), second.getShippriority(), second.getOrderkey());
            }
        });
        JoinOperator.EquiJoin joined = customerWithOrders.join((DataSet)li).where(new int[]{4}).equalTo(new int[]{0}).with((JoinFunction)new JoinFunction<ShippingPriorityItem, Lineitem, ShippingPriorityItem>(){

            public ShippingPriorityItem join(ShippingPriorityItem first, Lineitem second) {
                first.setL_Orderkey(second.getOrderkey());
                first.setRevenue(second.getExtendedprice() * (1.0 - second.getDiscount()));
                return first;
            }
        });
        joined = joined.groupBy(new int[]{0, 2, 3}).aggregate(Aggregations.SUM, 1);
        joined.writeAsCsv(outputPath, "\n", "|");
        env.execute("TPCH Query 3 Example");
    }

    private static void parseParameters(String[] programArguments) {
        if (programArguments.length > 0) {
            if (programArguments.length == 4) {
                lineitemPath = programArguments[0];
                customerPath = programArguments[1];
                ordersPath = programArguments[2];
                outputPath = programArguments[3];
            } else {
                System.err.println("Usage: TPCHQuery3 <lineitem-csv path> <customer-csv path> <orders-csv path> <result path>");
                System.exit(1);
            }
        } else {
            System.err.println("This program expects data from the TPC-H benchmark as input data.\n  Due to legal restrictions, we can not ship generated data.\n  You can find the TPC-H data generator at http://www.tpc.org/tpch/.\n  Usage: TPCHQuery3 <lineitem-csv path> <customer-csv path> <orders-csv path> <result path>");
            System.exit(1);
        }
    }

    private static DataSet<Lineitem> getLineitemDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(lineitemPath).fieldDelimiter('|').includeFields("1000011000100000").tupleType(Lineitem.class);
    }

    private static DataSet<Customer> getCustomerDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(customerPath).fieldDelimiter('|').includeFields("10000010").tupleType(Customer.class);
    }

    private static DataSet<Order> getOrdersDataSet(ExecutionEnvironment env) {
        return env.readCsvFile(ordersPath).fieldDelimiter('|').includeFields("100010010").tupleType(Order.class);
    }

    public static class ShippingPriorityItem
    extends Tuple5<Integer, Double, String, Integer, Integer> {
        public ShippingPriorityItem() {
        }

        public ShippingPriorityItem(Integer l_orderkey, Double revenue, String o_orderdate, Integer o_shippriority, Integer o_orderkey) {
            this.f0 = l_orderkey;
            this.f1 = revenue;
            this.f2 = o_orderdate;
            this.f3 = o_shippriority;
            this.f4 = o_orderkey;
        }

        public Integer getL_Orderkey() {
            return (Integer)this.f0;
        }

        public void setL_Orderkey(Integer l_orderkey) {
            this.f0 = l_orderkey;
        }

        public Double getRevenue() {
            return (Double)this.f1;
        }

        public void setRevenue(Double revenue) {
            this.f1 = revenue;
        }

        public String getOrderdate() {
            return (String)this.f2;
        }

        public Integer getShippriority() {
            return (Integer)this.f3;
        }

        public Integer getO_Orderkey() {
            return (Integer)this.f4;
        }
    }

    public static class Order
    extends Tuple3<Integer, String, Integer> {
        public Integer getOrderkey() {
            return (Integer)this.f0;
        }

        public String getOrderdate() {
            return (String)this.f1;
        }

        public Integer getShippriority() {
            return (Integer)this.f2;
        }
    }

    public static class Customer
    extends Tuple2<Integer, String> {
        public Integer getCustKey() {
            return (Integer)this.f0;
        }

        public String getMktsegment() {
            return (String)this.f1;
        }
    }

    public static class Lineitem
    extends Tuple4<Integer, Double, Double, String> {
        public Integer getOrderkey() {
            return (Integer)this.f0;
        }

        public Double getDiscount() {
            return (Double)this.f2;
        }

        public Double getExtendedprice() {
            return (Double)this.f1;
        }

        public String getShipdate() {
            return (String)this.f3;
        }
    }
}

