/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.record.relational;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.ProgramDescription;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.util.FieldSet;
import eu.stratosphere.api.java.record.functions.FunctionAnnotation;
import eu.stratosphere.api.java.record.functions.JoinFunction;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.io.CsvInputFormat;
import eu.stratosphere.api.java.record.io.CsvOutputFormat;
import eu.stratosphere.api.java.record.operators.JoinOperator;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Iterator;

public class TPCHQueryAsterix
implements Program,
ProgramDescription {
    public Plan getPlan(String ... args) {
        int numSubtasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String ordersPath = args.length > 1 ? args[1] : "";
        String customerPath = args.length > 2 ? args[2] : "";
        String output = args.length > 3 ? args[3] : "";
        FileDataSource orders = new FileDataSource((FileInputFormat)new CsvInputFormat(), ordersPath, "Orders");
        orders.setDegreeOfParallelism(numSubtasks);
        ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)CsvInputFormat.configureRecordFormat((FileDataSource)orders).recordDelimiter('\n')).fieldDelimiter('|')).field(IntValue.class, 1);
        orders.getCompilerHints().setAvgBytesPerRecord(5.0f);
        orders.getCompilerHints().setAvgNumRecordsPerDistinctFields(new FieldSet(new int[]{0}), 10.0f);
        FileDataSource customers = new FileDataSource((FileInputFormat)new CsvInputFormat(), customerPath, "Customers");
        customers.setDegreeOfParallelism(numSubtasks);
        ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)CsvInputFormat.configureRecordFormat((FileDataSource)customers).recordDelimiter('\n')).fieldDelimiter('|')).field(IntValue.class, 0)).field(StringValue.class, 6);
        customers.getCompilerHints().setAvgNumRecordsPerDistinctFields(new FieldSet(new int[]{0}), 1.0f);
        customers.getCompilerHints().setAvgBytesPerRecord(20.0f);
        JoinOperator joinCO = JoinOperator.builder((JoinFunction)new JoinCO(), IntValue.class, (int)0, (int)0).name("JoinCO").build();
        joinCO.setDegreeOfParallelism(numSubtasks);
        joinCO.getCompilerHints().setAvgBytesPerRecord(17.0f);
        ReduceOperator aggCO = ReduceOperator.builder((ReduceFunction)new AggCO(), StringValue.class, (int)1).name("AggCo").build();
        aggCO.setDegreeOfParallelism(numSubtasks);
        aggCO.getCompilerHints().setAvgBytesPerRecord(17.0f);
        aggCO.getCompilerHints().setAvgNumRecordsPerDistinctFields(new FieldSet(new int[]{0}), 1.0f);
        FileDataSink result = new FileDataSink((FileOutputFormat)new CsvOutputFormat(), output, "Output");
        result.setDegreeOfParallelism(numSubtasks);
        ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)result).recordDelimiter('\n')).fieldDelimiter('|')).field(IntValue.class, 0)).field(StringValue.class, 1);
        result.addInput((Operator)aggCO);
        aggCO.addInput(new Operator[]{joinCO});
        joinCO.addFirstInput(new Operator[]{orders});
        joinCO.addSecondInput(new Operator[]{customers});
        return new Plan((GenericDataSink)result, "TPCH Asterix");
    }

    public String getDescription() {
        return "Parameters: [numSubStasks], [orders], [customer], [output]";
    }

    @ReduceOperator.Combinable
    @FunctionAnnotation.ConstantFields(value={1})
    public static class AggCO
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IntValue integer = new IntValue();
        private Record record = new Record();

        public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
            int count = 0;
            while (records.hasNext()) {
                this.record = records.next();
                count += ((IntValue)this.record.getField(0, (Value)this.integer)).getValue();
            }
            this.integer.setValue(count);
            this.record.setField(0, (Value)this.integer);
            out.collect((Object)this.record);
        }

        public void combine(Iterator<Record> records, Collector<Record> out) throws Exception {
            this.reduce(records, out);
        }
    }

    @FunctionAnnotation.ConstantFieldsSecondExcept(value={0})
    public static class JoinCO
    extends JoinFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final IntValue one = new IntValue(1);

        public void match(Record order, Record cust, Collector<Record> out) throws Exception {
            cust.setField(0, (Value)this.one);
            out.collect((Object)cust);
        }
    }
}

