/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.record.pagerank;

import eu.stratosphere.api.java.record.io.TextInputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.example.java.record.pagerank.AsciiLongArrayView;
import eu.stratosphere.example.java.record.util.ConfigUtils;
import eu.stratosphere.types.BooleanValue;
import eu.stratosphere.types.DoubleValue;
import eu.stratosphere.types.LongValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;

public class DanglingPageRankInputFormat
extends TextInputFormat {
    private static final long serialVersionUID = 1L;
    public static final String NUM_VERTICES_PARAMETER = "pageRank.numVertices";
    private LongValue vertexID = new LongValue();
    private DoubleValue initialRank;
    private BooleanValue isDangling = new BooleanValue();
    private AsciiLongArrayView arrayView = new AsciiLongArrayView();
    private static final long DANGLING_MARKER = 1L;

    public void configure(Configuration parameters) {
        long numVertices = ConfigUtils.asLong(NUM_VERTICES_PARAMETER, parameters);
        this.initialRank = new DoubleValue(1.0 / (double)numVertices);
        super.configure(parameters);
    }

    public boolean readRecord(Record target, byte[] bytes, int offset, int numBytes) {
        this.arrayView.set(bytes, offset, numBytes);
        try {
            this.arrayView.next();
            this.vertexID.setValue(this.arrayView.element());
            if (this.arrayView.next()) {
                this.isDangling.set(this.arrayView.element() == 1L);
            } else {
                this.isDangling.set(false);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Error parsing " + this.arrayView.toString(), e);
        }
        target.clear();
        target.addField((Value)this.vertexID);
        target.addField((Value)this.initialRank);
        target.addField((Value)this.isDangling);
        return true;
    }
}

