/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.record.relational;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.Program;
import eu.stratosphere.api.common.ProgramDescription;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.FunctionAnnotation;
import eu.stratosphere.api.java.record.functions.JoinFunction;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.io.CsvInputFormat;
import eu.stratosphere.api.java.record.io.CsvOutputFormat;
import eu.stratosphere.api.java.record.operators.JoinOperator;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.DoubleValue;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.LongValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Iterator;

public class TPCHQuery3
implements Program,
ProgramDescription {
    public static final String YEAR_FILTER = "parameter.YEAR_FILTER";
    public static final String PRIO_FILTER = "parameter.PRIO_FILTER";

    public Plan getPlan(String ... args) {
        int numSubtasks = args.length > 0 ? Integer.parseInt(args[0]) : 1;
        String ordersPath = args.length > 1 ? args[1] : "";
        String lineitemsPath = args.length > 2 ? args[2] : "";
        String output = args.length > 3 ? args[3] : "";
        FileDataSource orders = new FileDataSource((FileInputFormat)new CsvInputFormat(), ordersPath, "Orders");
        ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)CsvInputFormat.configureRecordFormat((FileDataSource)orders).recordDelimiter('\n')).fieldDelimiter('|')).field(LongValue.class, 0)).field(IntValue.class, 7)).field(StringValue.class, 2, 2.0f)).field(StringValue.class, 4, 10.0f)).field(StringValue.class, 5, 8.0f);
        FileDataSource lineitems = new FileDataSource((FileInputFormat)new CsvInputFormat(), lineitemsPath, "LineItems");
        ((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)((CsvInputFormat.ConfigBuilder)CsvInputFormat.configureRecordFormat((FileDataSource)lineitems).recordDelimiter('\n')).fieldDelimiter('|')).field(LongValue.class, 0)).field(DoubleValue.class, 5);
        MapOperator filterO = MapOperator.builder((MapFunction)new FilterO()).input(new Operator[]{orders}).name("FilterO").build();
        filterO.setParameter(YEAR_FILTER, 1993);
        filterO.setParameter(PRIO_FILTER, "5");
        filterO.getCompilerHints().setAvgRecordsEmittedPerStubCall(0.05f);
        JoinOperator joinLiO = JoinOperator.builder((JoinFunction)new JoinLiO(), LongValue.class, (int)0, (int)0).input1(new Operator[]{filterO}).input2(new Operator[]{lineitems}).name("JoinLiO").build();
        ReduceOperator aggLiO = ReduceOperator.builder((ReduceFunction)new AggLiO()).keyField(LongValue.class, 0).keyField(StringValue.class, 1).input(new Operator[]{joinLiO}).name("AggLio").build();
        FileDataSink result = new FileDataSink((FileOutputFormat)new CsvOutputFormat(), output, (Operator)aggLiO, "Output");
        ((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)((CsvOutputFormat.ConfigBuilder)CsvOutputFormat.configureRecordFormat((FileDataSink)result).recordDelimiter('\n')).fieldDelimiter('|')).lenient(true)).field(LongValue.class, 0)).field(IntValue.class, 1)).field(DoubleValue.class, 2);
        Plan plan = new Plan((GenericDataSink)result, "TPCH Q3");
        plan.setDefaultParallelism(numSubtasks);
        return plan;
    }

    public String getDescription() {
        return "Parameters: [numSubStasks], [orders], [lineitem], [output]";
    }

    @ReduceOperator.Combinable
    @FunctionAnnotation.ConstantFields(value={0, 1})
    public static class AggLiO
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DoubleValue extendedPrice = new DoubleValue();

        public void reduce(Iterator<Record> values, Collector<Record> out) {
            Record rec = null;
            double partExtendedPriceSum = 0.0;
            while (values.hasNext()) {
                rec = values.next();
                partExtendedPriceSum += ((DoubleValue)rec.getField(2, DoubleValue.class)).getValue();
            }
            this.extendedPrice.setValue(partExtendedPriceSum);
            rec.setField(2, (Value)this.extendedPrice);
            out.collect((Object)rec);
        }

        public void combine(Iterator<Record> values, Collector<Record> out) {
            this.reduce(values, out);
        }
    }

    @FunctionAnnotation.ConstantFieldsFirst(value={0, 1})
    public static class JoinLiO
    extends JoinFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void match(Record order, Record lineitem, Collector<Record> out) {
            order.setField(2, lineitem.getField(1, DoubleValue.class));
            out.collect((Object)order);
        }
    }

    @FunctionAnnotation.ConstantFields(value={0, 1})
    public static class FilterO
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String prioFilter;
        private int yearFilter;
        private StringValue orderStatus;
        private StringValue orderDate;
        private StringValue orderPrio;

        public void open(Configuration parameters) {
            this.yearFilter = parameters.getInteger(TPCHQuery3.YEAR_FILTER, 1990);
            this.prioFilter = parameters.getString(TPCHQuery3.PRIO_FILTER, "0");
        }

        public void map(Record record, Collector<Record> out) {
            this.orderStatus = (StringValue)record.getField(2, StringValue.class);
            if (!this.orderStatus.getValue().equals("F")) {
                return;
            }
            this.orderPrio = (StringValue)record.getField(4, StringValue.class);
            if (!this.orderPrio.getValue().startsWith(this.prioFilter)) {
                return;
            }
            this.orderDate = (StringValue)record.getField(3, StringValue.class);
            if (Integer.parseInt(this.orderDate.getValue().substring(0, 4)) <= this.yearFilter) {
                return;
            }
            record.setNumFields(2);
            out.collect((Object)record);
        }
    }
}

