/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.record.kmeans.udfs;

import eu.stratosphere.types.Key;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class CoordVector
implements Key {
    private static final long serialVersionUID = 1L;
    private double[] coordinates;

    public CoordVector() {
        this.coordinates = null;
    }

    public CoordVector(Double[] coordinates) {
        this.coordinates = new double[coordinates.length];
        for (int i = 0; i < coordinates.length; ++i) {
            this.coordinates[i] = coordinates[i];
        }
    }

    public CoordVector(double[] coordinates) {
        this.coordinates = coordinates;
    }

    public double[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        this.coordinates = coordinates;
    }

    public double computeEuclidianDistance(CoordVector cv) {
        if (cv.coordinates.length != this.coordinates.length) {
            return -1.0;
        }
        double quadSum = 0.0;
        for (int i = 0; i < this.coordinates.length; ++i) {
            double diff = this.coordinates[i] - cv.coordinates[i];
            quadSum += diff * diff;
        }
        return Math.sqrt(quadSum);
    }

    public void read(DataInput in) throws IOException {
        int length = in.readInt();
        this.coordinates = new double[length];
        for (int i = 0; i < length; ++i) {
            this.coordinates[i] = in.readDouble();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.coordinates.length);
        for (int i = 0; i < this.coordinates.length; ++i) {
            out.writeDouble(this.coordinates[i]);
        }
    }

    public int compareTo(Key o) {
        if (!(o instanceof CoordVector)) {
            return -1;
        }
        CoordVector oP = (CoordVector)o;
        if (oP.coordinates.length > this.coordinates.length) {
            return -1;
        }
        if (oP.coordinates.length < this.coordinates.length) {
            return 1;
        }
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (oP.coordinates[i] > this.coordinates[i]) {
                return -1;
            }
            if (!(oP.coordinates[i] < this.coordinates[i])) continue;
            return 1;
        }
        return 0;
    }
}

