/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.record.relational.generator;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Random;

public class WebLogGenerator {
    public static void main(String[] args) {
        if (args.length != 4) {
            if (args.length == 0 || args[0].equals("-h") || args[0].equals("--help")) {
                System.out.println("Usage:");
                System.out.println("1:\tWith parameters");
                System.out.println("\t<Generator> [noDocuments] [noVisits] [outPath] [noFiles]");
                System.out.println("2:\tDefault parameters");
                System.out.println("\t<Generator> -d");
                return;
            }
            if (args[0].equals("-d")) {
                args = new String[]{"1000", "10000", "/tmp/stratosphere/", "1"};
            }
        }
        String[] filterKWs = new String[]{"editors", "oscillations", "convection"};
        String[] words = new String[]{"Lorem", "ipsum", "dolor", "sit", "amet", "consectetuer", "adipiscing", "elit", "sed", "diam", "nonummy", "nibh", "euismod", "tincidunt", "ut", "laoreet", "dolore", "magna", "aliquam", "erat", "volutpat", "Ut", "wisi", "enim", "ad", "minim", "veniam", "quis", "nostrud", "exerci", "tation", "ullamcorper", "suscipit", "lobortis", "nisl", "ut", "aliquip", "ex", "ea", "commodo"};
        int noDocs = Integer.parseInt(args[0]);
        int noVisits = Integer.parseInt(args[1]);
        String path = args[2];
        int noFiles = Integer.parseInt(args[3]);
        System.out.println("Generating documents files...");
        WebLogGenerator.genDocs(noDocs, noFiles, filterKWs, words, path + "docs_");
        System.out.println("Generating ranks files...");
        WebLogGenerator.genRanks(noDocs, noFiles, path + "ranks_");
        System.out.println("Generating visits files...");
        WebLogGenerator.genVisits(noVisits, noDocs, noFiles, path + "visits_");
        System.out.println("Done!");
    }

    public static void genDocs(int noDocs, int noFiles, String[] filterKeyWords, String[] words, String path) {
        Random rand = new Random(Calendar.getInstance().getTimeInMillis());
        int fileId = 0;
        int docsPerFile = noDocs / noFiles + 1;
        int docsInFile = 0;
        try {
            FileWriter fw = new FileWriter(path + fileId++);
            for (int i = 0; i < noDocs; ++i) {
                int wordsInDoc = rand.nextInt(40) + 10;
                StringBuilder doc = new StringBuilder("url_" + i + "|");
                for (int j = 0; j < wordsInDoc; ++j) {
                    if (rand.nextDouble() > 0.98) {
                        doc.append(filterKeyWords[rand.nextInt(filterKeyWords.length)] + " ");
                        continue;
                    }
                    doc.append(words[rand.nextInt(words.length)] + " ");
                }
                doc.append("|\n");
                fw.write(doc.toString());
                if (++docsInFile != docsPerFile) continue;
                fw.close();
                fw = new FileWriter(path + fileId++);
                docsInFile = 0;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void genRanks(int noDocs, int noFiles, String path) {
        Random rand = new Random(Calendar.getInstance().getTimeInMillis());
        int fileId = 0;
        int docsPerFile = noDocs / noFiles + 1;
        int docsInFile = 0;
        try {
            FileWriter fw = new FileWriter(path + fileId++);
            for (int i = 0; i < noDocs; ++i) {
                StringBuilder rank = new StringBuilder(rand.nextInt(100) + "|");
                rank.append("url_" + i + "|");
                rank.append(rand.nextInt(10) + rand.nextInt(50) + "|\n");
                fw.write(rank.toString());
                if (++docsInFile != docsPerFile) continue;
                fw.close();
                fw = new FileWriter(path + fileId++);
                docsInFile = 0;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void genVisits(int noVisits, int noDocs, int noFiles, String path) {
        Random rand = new Random(Calendar.getInstance().getTimeInMillis());
        int fileId = 0;
        int visitsPerFile = noVisits / noFiles + 1;
        int visitsInFile = 0;
        try {
            FileWriter fw = new FileWriter(path + fileId++);
            for (int i = 0; i < noVisits; ++i) {
                int year = 2000 + rand.nextInt(10);
                int month = rand.nextInt(12) + 1;
                int day = rand.nextInt(27) + 1;
                StringBuilder visit = new StringBuilder(rand.nextInt(256) + "." + rand.nextInt(256) + "." + rand.nextInt(256) + "." + rand.nextInt(256) + "|");
                visit.append("url_" + rand.nextInt(noDocs) + "|");
                visit.append(year + "-" + month + "-" + day + "|");
                visit.append("0.12|Mozilla Firefox 3.1|de|de|Nothing special|124|\n");
                fw.write(visit.toString());
                if (++visitsInFile != visitsPerFile) continue;
                fw.close();
                fw = new FileWriter(path + fileId++);
                visitsInFile = 0;
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

