/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.example.java.record.kmeans.udfs;

import eu.stratosphere.api.java.record.io.DelimitedInputFormat;
import eu.stratosphere.example.java.record.kmeans.udfs.CoordVector;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import java.util.ArrayList;
import java.util.List;

public class PointInFormat
extends DelimitedInputFormat {
    private static final long serialVersionUID = 1L;
    private final IntValue idInteger = new IntValue();
    private final CoordVector point = new CoordVector();
    private final List<Double> dimensionValues = new ArrayList<Double>();
    private double[] pointValues = new double[0];

    public boolean readRecord(Record record, byte[] line, int offset, int numBytes) {
        int limit = offset + numBytes;
        int id = -1;
        int value = 0;
        int fractionValue = 0;
        int fractionChars = 0;
        boolean negative = false;
        this.dimensionValues.clear();
        for (int pos = offset; pos < limit; ++pos) {
            if (line[pos] == 124) {
                if (id == -1) {
                    id = value;
                } else {
                    double v = (double)value + (double)fractionValue * Math.pow(10.0, -1 * (fractionChars - 1));
                    this.dimensionValues.add(negative ? -v : v);
                }
                value = 0;
                fractionValue = 0;
                fractionChars = 0;
                negative = false;
                continue;
            }
            if (line[pos] == 46) {
                fractionChars = 1;
                continue;
            }
            if (line[pos] == 45) {
                negative = true;
                continue;
            }
            if (fractionChars == 0) {
                value *= 10;
                value += line[pos] - 48;
                continue;
            }
            fractionValue *= 10;
            fractionValue += line[pos] - 48;
            ++fractionChars;
        }
        this.idInteger.setValue(id);
        record.setField(0, (Value)this.idInteger);
        if (this.pointValues.length != this.dimensionValues.size()) {
            this.pointValues = new double[this.dimensionValues.size()];
        }
        for (int i = 0; i < this.pointValues.length; ++i) {
            this.pointValues[i] = this.dimensionValues.get(i);
        }
        this.point.setCoordinates(this.pointValues);
        record.setField(1, (Value)this.point);
        return true;
    }
}

