/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.spargel.java.record;

import eu.stratosphere.api.common.aggregators.Aggregator;
import eu.stratosphere.api.common.functions.IterationRuntimeContext;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.spargel.java.record.MessageIterator;
import eu.stratosphere.types.Key;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;

public abstract class VertexUpdateFunction<VertexKey extends Key<VertexKey>, VertexValue extends Value, Message extends Value>
implements Serializable {
    private IterationRuntimeContext runtimeContext;
    private Collector<Record> out;
    private Record outVal;
    private static final long serialVersionUID = 1L;

    public abstract void updateVertex(VertexKey var1, VertexValue var2, MessageIterator<Message> var3) throws Exception;

    public void setup(Configuration config) throws Exception {
    }

    public void preSuperstep() throws Exception {
    }

    public void postSuperstep() throws Exception {
    }

    public void setNewVertexValue(VertexValue newValue) {
        this.outVal.setField(1, newValue);
        this.out.collect((Object)this.outVal);
    }

    public int getSuperstep() {
        return this.runtimeContext.getSuperstepNumber();
    }

    public <T extends Aggregator<?>> T getIterationAggregator(String name) {
        return (T)this.runtimeContext.getIterationAggregator(name);
    }

    public <T extends Value> T getPreviousIterationAggregate(String name) {
        return (T)this.runtimeContext.getPreviousIterationAggregate(name);
    }

    void init(IterationRuntimeContext context) {
        this.runtimeContext = context;
    }

    void setOutput(Record val, Collector<Record> out) {
        this.out = out;
        this.outVal = val;
    }
}

