/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.spargel.java.record;

import eu.stratosphere.api.common.aggregators.Aggregator;
import eu.stratosphere.api.common.functions.IterationRuntimeContext;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.spargel.java.record.Edge;
import eu.stratosphere.types.Key;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.Serializable;
import java.util.Iterator;

public abstract class MessagingFunction<VertexKey extends Key<VertexKey>, VertexValue extends Value, Message extends Value, EdgeValue extends Value>
implements Serializable {
    private Record outValue;
    private IterationRuntimeContext runtimeContext;
    private Iterator<Record> edges;
    private Collector<Record> out;
    private EdgesIterator<VertexKey, EdgeValue> edgeIter;
    private Class<VertexKey> keyClass;
    private boolean edgesUsed;
    private static final long serialVersionUID = 1L;

    public abstract void sendMessages(VertexKey var1, VertexValue var2) throws Exception;

    public void setup(Configuration config) throws Exception {
    }

    public void preSuperstep() throws Exception {
    }

    public void postSuperstep() throws Exception {
    }

    public Iterator<Edge<VertexKey, EdgeValue>> getOutgoingEdges() {
        if (this.edgesUsed) {
            throw new IllegalStateException("Can use either 'getOutgoingEdges()' or 'sendMessageToAllTargets()'.");
        }
        this.edgesUsed = true;
        this.edgeIter.set(this.edges);
        return this.edgeIter;
    }

    public void sendMessageToAllNeighbors(Message m) {
        if (this.edgesUsed) {
            throw new IllegalStateException("Can use either 'getOutgoingEdges()' or 'sendMessageToAllTargets()'.");
        }
        this.edgesUsed = true;
        while (this.edges.hasNext()) {
            Record next = this.edges.next();
            Key k = (Key)next.getField(1, this.keyClass);
            this.outValue.setField(0, (Value)k);
            this.outValue.setField(1, m);
            this.out.collect((Object)this.outValue);
        }
    }

    public void sendMessageTo(VertexKey target, Message m) {
        this.outValue.setField(0, target);
        this.outValue.setField(1, m);
        this.out.collect((Object)this.outValue);
    }

    public int getSuperstep() {
        return this.runtimeContext.getSuperstepNumber();
    }

    public <T extends Aggregator<?>> T getIterationAggregator(String name) {
        return (T)this.runtimeContext.getIterationAggregator(name);
    }

    public <T extends Value> T getPreviousIterationAggregate(String name) {
        return (T)this.runtimeContext.getPreviousIterationAggregate(name);
    }

    void init(IterationRuntimeContext context, VertexKey keyHolder, EdgeValue edgeValueHolder) {
        this.runtimeContext = context;
        this.edgeIter = new EdgesIterator<VertexKey, EdgeValue>(keyHolder, edgeValueHolder);
        this.outValue = new Record();
        this.keyClass = keyHolder.getClass();
    }

    void set(Iterator<Record> edges, Collector<Record> out) {
        this.edges = edges;
        this.out = out;
        this.edgesUsed = false;
    }

    private static final class EdgesIterator<VertexKey extends Key<VertexKey>, EdgeValue extends Value>
    implements Iterator<Edge<VertexKey, EdgeValue>> {
        private Iterator<Record> input;
        private VertexKey keyHolder;
        private EdgeValue edgeValueHolder;
        private Edge<VertexKey, EdgeValue> edge = new Edge();

        EdgesIterator(VertexKey keyHolder, EdgeValue edgeValueHolder) {
            this.keyHolder = keyHolder;
            this.edgeValueHolder = edgeValueHolder;
        }

        void set(Iterator<Record> input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.input.hasNext();
        }

        @Override
        public Edge<VertexKey, EdgeValue> next() {
            Record next = this.input.next();
            next.getFieldInto(0, this.keyHolder);
            next.getFieldInto(1, this.edgeValueHolder);
            this.edge.set(this.keyHolder, this.edgeValueHolder);
            return this.edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

