/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.testing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.sopremo.operator.Operator;
import eu.stratosphere.sopremo.operator.SopremoPlan;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.junit.Assert;

public class SopremoTestUtil {
    public static void assertPlanEquals(SopremoPlan expectedPlan, SopremoPlan actualPlan) {
        Kryo kryo = expectedPlan.getCompilationContext().getKryo();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeObject(output, (Object)actualPlan);
        output.close();
        actualPlan = (SopremoPlan)kryo.readObject(new Input(baos.toByteArray()), SopremoPlan.class);
        List unmatchingOperators = actualPlan.getUnmatchingOperators(expectedPlan);
        if (!unmatchingOperators.isEmpty()) {
            if (((Operator)unmatchingOperators.get(0)).getClass() == ((Operator)unmatchingOperators.get(1)).getClass()) {
                Assert.fail((String)("operators are different\nexpected: " + unmatchingOperators.get(1) + "\nbut was: " + unmatchingOperators.get(0)));
            } else {
                Assert.fail((String)("plans are different\nexpected: " + expectedPlan + "\nbut was: " + actualPlan));
            }
        }
    }

    public static String createTemporaryFile(String prefix) {
        try {
            File tempFile = File.createTempFile(prefix, ".json");
            tempFile.deleteOnExit();
            return tempFile.toURI().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create temporary file", e);
        }
    }

    public static String getResourcePath(String resource) {
        try {
            Enumeration<URL> resources = SopremoTestUtil.class.getClassLoader().getResources(resource);
            if (resources.hasMoreElements()) {
                return resources.nextElement().toString();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        throw new IllegalArgumentException("no resources found");
    }
}

