/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.testing;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.EqualCloneTest;
import eu.stratosphere.sopremo.io.Sink;
import eu.stratosphere.sopremo.operator.JsonStream;
import eu.stratosphere.sopremo.operator.Operator;
import eu.stratosphere.sopremo.operator.SopremoPlan;
import eu.stratosphere.util.SopremoKryo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public abstract class SopremoOperatorTestBase<T extends Operator<T>>
extends EqualCloneTest<T> {
    @Test
    public void testPlanClone() throws IllegalAccessException {
        for (Operator original : this.getInstances()) {
            SopremoPlan plan = new SopremoPlan();
            int numOutputs = original.getNumOutputs();
            if (numOutputs == 0) continue;
            ArrayList<Operator> sinks = new ArrayList<Operator>();
            for (int index = 0; index < numOutputs; ++index) {
                sinks.add(new Sink("file:///out" + index).withInputs(new JsonStream[]{original.getOutput(index)}));
            }
            plan.setSinks(sinks);
            AbstractSopremoType clone = plan.clone();
            this.testPropertyClone(SopremoPlan.class, plan, clone);
        }
    }

    @Test
    public void testPlanSerialization() {
        SopremoKryo k = new SopremoKryo();
        for (Operator original : this.getInstances()) {
            SopremoPlan plan = new SopremoPlan();
            plan.setSinks(new Sink[]{(Sink)new Sink("file:///dummy").withInputs(new JsonStream[]{original})});
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)baos);
            k.writeClassAndObject(output, (Object)plan);
            output.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            SopremoPlan deserialized = (SopremoPlan)k.readClassAndObject(new Input((InputStream)bais));
            Assert.assertEquals((Object)plan, (Object)deserialized);
        }
    }

    protected List<T> getInstances() {
        ArrayList<Object> instances = new ArrayList<Object>();
        instances.add(this.first);
        instances.add(this.second);
        instances.addAll(this.more);
        return instances;
    }
}

